/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ses.model.DeleteConfigurationSetRequest;

public class DeleteConfigurationSetRequestMarshaller
implements Marshaller<Request<DeleteConfigurationSetRequest>, DeleteConfigurationSetRequest> {
    public Request<DeleteConfigurationSetRequest> marshall(DeleteConfigurationSetRequest deleteConfigurationSetRequest) {
        if (deleteConfigurationSetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteConfigurationSetRequest, "SESClient");
        request.addParameter("Action", "DeleteConfigurationSet");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteConfigurationSetRequest.configurationSetName() != null) {
            request.addParameter("ConfigurationSetName", StringUtils.fromString((String)deleteConfigurationSetRequest.configurationSetName()));
        }
        return request;
    }
}

