/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ses.model.CreateConfigurationSetTrackingOptionsRequest;
import software.amazon.awssdk.services.ses.model.TrackingOptions;

public class CreateConfigurationSetTrackingOptionsRequestMarshaller
implements Marshaller<Request<CreateConfigurationSetTrackingOptionsRequest>, CreateConfigurationSetTrackingOptionsRequest> {
    public Request<CreateConfigurationSetTrackingOptionsRequest> marshall(CreateConfigurationSetTrackingOptionsRequest createConfigurationSetTrackingOptionsRequest) {
        TrackingOptions trackingOptions;
        if (createConfigurationSetTrackingOptionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createConfigurationSetTrackingOptionsRequest, "SESClient");
        request.addParameter("Action", "CreateConfigurationSetTrackingOptions");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createConfigurationSetTrackingOptionsRequest.configurationSetName() != null) {
            request.addParameter("ConfigurationSetName", StringUtils.fromString((String)createConfigurationSetTrackingOptionsRequest.configurationSetName()));
        }
        if ((trackingOptions = createConfigurationSetTrackingOptionsRequest.trackingOptions()) != null && trackingOptions.customRedirectDomain() != null) {
            request.addParameter("TrackingOptions.CustomRedirectDomain", StringUtils.fromString((String)trackingOptions.customRedirectDomain()));
        }
        return request;
    }
}

