/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ses.model.CloneReceiptRuleSetRequest;

public class CloneReceiptRuleSetRequestMarshaller
implements Marshaller<Request<CloneReceiptRuleSetRequest>, CloneReceiptRuleSetRequest> {
    public Request<CloneReceiptRuleSetRequest> marshall(CloneReceiptRuleSetRequest cloneReceiptRuleSetRequest) {
        if (cloneReceiptRuleSetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)cloneReceiptRuleSetRequest, "SESClient");
        request.addParameter("Action", "CloneReceiptRuleSet");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (cloneReceiptRuleSetRequest.ruleSetName() != null) {
            request.addParameter("RuleSetName", StringUtils.fromString((String)cloneReceiptRuleSetRequest.ruleSetName()));
        }
        if (cloneReceiptRuleSetRequest.originalRuleSetName() != null) {
            request.addParameter("OriginalRuleSetName", StringUtils.fromString((String)cloneReceiptRuleSetRequest.originalRuleSetName()));
        }
        return request;
    }
}

