/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TestRenderTemplateRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, TestRenderTemplateRequest> {
    private final String templateName;
    private final String templateData;

    private TestRenderTemplateRequest(BuilderImpl builder) {
        this.templateName = builder.templateName;
        this.templateData = builder.templateData;
    }

    public String templateName() {
        return this.templateName;
    }

    public String templateData() {
        return this.templateData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateData());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestRenderTemplateRequest)) {
            return false;
        }
        TestRenderTemplateRequest other = (TestRenderTemplateRequest)((Object)obj);
        return Objects.equals(this.templateName(), other.templateName()) && Objects.equals(this.templateData(), other.templateData());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.templateName() != null) {
            sb.append("TemplateName: ").append(this.templateName()).append(",");
        }
        if (this.templateData() != null) {
            sb.append("TemplateData: ").append(this.templateData()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TemplateName": {
                return Optional.of(clazz.cast(this.templateName()));
            }
            case "TemplateData": {
                return Optional.of(clazz.cast(this.templateData()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String templateName;
        private String templateData;

        private BuilderImpl() {
        }

        private BuilderImpl(TestRenderTemplateRequest model) {
            this.templateName(model.templateName);
            this.templateData(model.templateData);
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public final String getTemplateData() {
            return this.templateData;
        }

        @Override
        public final Builder templateData(String templateData) {
            this.templateData = templateData;
            return this;
        }

        public final void setTemplateData(String templateData) {
            this.templateData = templateData;
        }

        public TestRenderTemplateRequest build() {
            return new TestRenderTemplateRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TestRenderTemplateRequest> {
        public Builder templateName(String var1);

        public Builder templateData(String var1);
    }
}

