/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SetReceiptRulePositionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, SetReceiptRulePositionRequest> {
    private final String ruleSetName;
    private final String ruleName;
    private final String after;

    private SetReceiptRulePositionRequest(BuilderImpl builder) {
        this.ruleSetName = builder.ruleSetName;
        this.ruleName = builder.ruleName;
        this.after = builder.after;
    }

    public String ruleSetName() {
        return this.ruleSetName;
    }

    public String ruleName() {
        return this.ruleName;
    }

    public String after() {
        return this.after;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.after());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetReceiptRulePositionRequest)) {
            return false;
        }
        SetReceiptRulePositionRequest other = (SetReceiptRulePositionRequest)((Object)obj);
        return Objects.equals(this.ruleSetName(), other.ruleSetName()) && Objects.equals(this.ruleName(), other.ruleName()) && Objects.equals(this.after(), other.after());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.ruleSetName() != null) {
            sb.append("RuleSetName: ").append(this.ruleSetName()).append(",");
        }
        if (this.ruleName() != null) {
            sb.append("RuleName: ").append(this.ruleName()).append(",");
        }
        if (this.after() != null) {
            sb.append("After: ").append(this.after()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleSetName": {
                return Optional.of(clazz.cast(this.ruleSetName()));
            }
            case "RuleName": {
                return Optional.of(clazz.cast(this.ruleName()));
            }
            case "After": {
                return Optional.of(clazz.cast(this.after()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String ruleSetName;
        private String ruleName;
        private String after;

        private BuilderImpl() {
        }

        private BuilderImpl(SetReceiptRulePositionRequest model) {
            this.ruleSetName(model.ruleSetName);
            this.ruleName(model.ruleName);
            this.after(model.after);
        }

        public final String getRuleSetName() {
            return this.ruleSetName;
        }

        @Override
        public final Builder ruleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
            return this;
        }

        public final void setRuleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
        }

        public final String getRuleName() {
            return this.ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        public final String getAfter() {
            return this.after;
        }

        @Override
        public final Builder after(String after) {
            this.after = after;
            return this;
        }

        public final void setAfter(String after) {
            this.after = after;
        }

        public SetReceiptRulePositionRequest build() {
            return new SetReceiptRulePositionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SetReceiptRulePositionRequest> {
        public Builder ruleSetName(String var1);

        public Builder ruleName(String var1);

        public Builder after(String var1);
    }
}

