/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteIdentityPolicyRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteIdentityPolicyRequest> {
    private final String identity;
    private final String policyName;

    private DeleteIdentityPolicyRequest(BuilderImpl builder) {
        this.identity = builder.identity;
        this.policyName = builder.policyName;
    }

    public String identity() {
        return this.identity;
    }

    public String policyName() {
        return this.policyName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identity());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteIdentityPolicyRequest)) {
            return false;
        }
        DeleteIdentityPolicyRequest other = (DeleteIdentityPolicyRequest)((Object)obj);
        return Objects.equals(this.identity(), other.identity()) && Objects.equals(this.policyName(), other.policyName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.identity() != null) {
            sb.append("Identity: ").append(this.identity()).append(",");
        }
        if (this.policyName() != null) {
            sb.append("PolicyName: ").append(this.policyName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Identity": {
                return Optional.of(clazz.cast(this.identity()));
            }
            case "PolicyName": {
                return Optional.of(clazz.cast(this.policyName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String identity;
        private String policyName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteIdentityPolicyRequest model) {
            this.identity(model.identity);
            this.policyName(model.policyName);
        }

        public final String getIdentity() {
            return this.identity;
        }

        @Override
        public final Builder identity(String identity) {
            this.identity = identity;
            return this;
        }

        public final void setIdentity(String identity) {
            this.identity = identity;
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public DeleteIdentityPolicyRequest build() {
            return new DeleteIdentityPolicyRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteIdentityPolicyRequest> {
        public Builder identity(String var1);

        public Builder policyName(String var1);
    }
}

