/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.ses.model.Content;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Body
implements ToCopyableBuilder<Builder, Body> {
    private final Content text;
    private final Content html;

    private Body(BuilderImpl builder) {
        this.text = builder.text;
        this.html = builder.html;
    }

    public Content text() {
        return this.text;
    }

    public Content html() {
        return this.html;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.html());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Body)) {
            return false;
        }
        Body other = (Body)obj;
        return Objects.equals(this.text(), other.text()) && Objects.equals(this.html(), other.html());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.text() != null) {
            sb.append("Text: ").append(this.text()).append(",");
        }
        if (this.html() != null) {
            sb.append("Html: ").append(this.html()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Text": {
                return Optional.of(clazz.cast(this.text()));
            }
            case "Html": {
                return Optional.of(clazz.cast(this.html()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Content text;
        private Content html;

        private BuilderImpl() {
        }

        private BuilderImpl(Body model) {
            this.text(model.text);
            this.html(model.html);
        }

        public final Content.Builder getText() {
            return this.text != null ? this.text.toBuilder() : null;
        }

        @Override
        public final Builder text(Content text) {
            this.text = text;
            return this;
        }

        public final void setText(Content.BuilderImpl text) {
            this.text = text != null ? text.build() : null;
        }

        public final Content.Builder getHtml() {
            return this.html != null ? this.html.toBuilder() : null;
        }

        @Override
        public final Builder html(Content html) {
            this.html = html;
            return this;
        }

        public final void setHtml(Content.BuilderImpl html) {
            this.html = html != null ? html.build() : null;
        }

        public Body build() {
            return new Body(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Body> {
        public Builder text(Content var1);

        default public Builder text(Consumer<Content.Builder> text) {
            return this.text((Content)((Content.Builder)Content.builder().apply(text)).build());
        }

        public Builder html(Content var1);

        default public Builder html(Consumer<Content.Builder> html) {
            return this.html((Content)((Content.Builder)Content.builder().apply(html)).build());
        }
    }
}

