/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ses.model.SetIdentityNotificationTopicRequest;

public class SetIdentityNotificationTopicRequestMarshaller
implements Marshaller<Request<SetIdentityNotificationTopicRequest>, SetIdentityNotificationTopicRequest> {
    public Request<SetIdentityNotificationTopicRequest> marshall(SetIdentityNotificationTopicRequest setIdentityNotificationTopicRequest) {
        if (setIdentityNotificationTopicRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)setIdentityNotificationTopicRequest, "SESClient");
        request.addParameter("Action", "SetIdentityNotificationTopic");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (setIdentityNotificationTopicRequest.identity() != null) {
            request.addParameter("Identity", StringUtils.fromString((String)setIdentityNotificationTopicRequest.identity()));
        }
        if (setIdentityNotificationTopicRequest.notificationTypeString() != null) {
            request.addParameter("NotificationType", StringUtils.fromString((String)setIdentityNotificationTopicRequest.notificationTypeString()));
        }
        if (setIdentityNotificationTopicRequest.snsTopic() != null) {
            request.addParameter("SnsTopic", StringUtils.fromString((String)setIdentityNotificationTopicRequest.snsTopic()));
        }
        return request;
    }
}

