/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ses.model.BouncedRecipientInfo;
import software.amazon.awssdk.services.ses.model.BouncedRecipientInfoListCopier;
import software.amazon.awssdk.services.ses.model.MessageDsn;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SendBounceRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, SendBounceRequest> {
    private final String originalMessageId;
    private final String bounceSender;
    private final String explanation;
    private final MessageDsn messageDsn;
    private final List<BouncedRecipientInfo> bouncedRecipientInfoList;
    private final String bounceSenderArn;

    private SendBounceRequest(BuilderImpl builder) {
        this.originalMessageId = builder.originalMessageId;
        this.bounceSender = builder.bounceSender;
        this.explanation = builder.explanation;
        this.messageDsn = builder.messageDsn;
        this.bouncedRecipientInfoList = builder.bouncedRecipientInfoList;
        this.bounceSenderArn = builder.bounceSenderArn;
    }

    public String originalMessageId() {
        return this.originalMessageId;
    }

    public String bounceSender() {
        return this.bounceSender;
    }

    public String explanation() {
        return this.explanation;
    }

    public MessageDsn messageDsn() {
        return this.messageDsn;
    }

    public List<BouncedRecipientInfo> bouncedRecipientInfoList() {
        return this.bouncedRecipientInfoList;
    }

    public String bounceSenderArn() {
        return this.bounceSenderArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.originalMessageId() == null ? 0 : this.originalMessageId().hashCode());
        hashCode = 31 * hashCode + (this.bounceSender() == null ? 0 : this.bounceSender().hashCode());
        hashCode = 31 * hashCode + (this.explanation() == null ? 0 : this.explanation().hashCode());
        hashCode = 31 * hashCode + (this.messageDsn() == null ? 0 : this.messageDsn().hashCode());
        hashCode = 31 * hashCode + (this.bouncedRecipientInfoList() == null ? 0 : this.bouncedRecipientInfoList().hashCode());
        hashCode = 31 * hashCode + (this.bounceSenderArn() == null ? 0 : this.bounceSenderArn().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendBounceRequest)) {
            return false;
        }
        SendBounceRequest other = (SendBounceRequest)((Object)obj);
        if (other.originalMessageId() == null ^ this.originalMessageId() == null) {
            return false;
        }
        if (other.originalMessageId() != null && !other.originalMessageId().equals(this.originalMessageId())) {
            return false;
        }
        if (other.bounceSender() == null ^ this.bounceSender() == null) {
            return false;
        }
        if (other.bounceSender() != null && !other.bounceSender().equals(this.bounceSender())) {
            return false;
        }
        if (other.explanation() == null ^ this.explanation() == null) {
            return false;
        }
        if (other.explanation() != null && !other.explanation().equals(this.explanation())) {
            return false;
        }
        if (other.messageDsn() == null ^ this.messageDsn() == null) {
            return false;
        }
        if (other.messageDsn() != null && !other.messageDsn().equals(this.messageDsn())) {
            return false;
        }
        if (other.bouncedRecipientInfoList() == null ^ this.bouncedRecipientInfoList() == null) {
            return false;
        }
        if (other.bouncedRecipientInfoList() != null && !other.bouncedRecipientInfoList().equals(this.bouncedRecipientInfoList())) {
            return false;
        }
        if (other.bounceSenderArn() == null ^ this.bounceSenderArn() == null) {
            return false;
        }
        return other.bounceSenderArn() == null || other.bounceSenderArn().equals(this.bounceSenderArn());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.originalMessageId() != null) {
            sb.append("OriginalMessageId: ").append(this.originalMessageId()).append(",");
        }
        if (this.bounceSender() != null) {
            sb.append("BounceSender: ").append(this.bounceSender()).append(",");
        }
        if (this.explanation() != null) {
            sb.append("Explanation: ").append(this.explanation()).append(",");
        }
        if (this.messageDsn() != null) {
            sb.append("MessageDsn: ").append(this.messageDsn()).append(",");
        }
        if (this.bouncedRecipientInfoList() != null) {
            sb.append("BouncedRecipientInfoList: ").append(this.bouncedRecipientInfoList()).append(",");
        }
        if (this.bounceSenderArn() != null) {
            sb.append("BounceSenderArn: ").append(this.bounceSenderArn()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OriginalMessageId": {
                return Optional.of(clazz.cast(this.originalMessageId()));
            }
            case "BounceSender": {
                return Optional.of(clazz.cast(this.bounceSender()));
            }
            case "Explanation": {
                return Optional.of(clazz.cast(this.explanation()));
            }
            case "MessageDsn": {
                return Optional.of(clazz.cast(this.messageDsn()));
            }
            case "BouncedRecipientInfoList": {
                return Optional.of(clazz.cast(this.bouncedRecipientInfoList()));
            }
            case "BounceSenderArn": {
                return Optional.of(clazz.cast(this.bounceSenderArn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String originalMessageId;
        private String bounceSender;
        private String explanation;
        private MessageDsn messageDsn;
        private List<BouncedRecipientInfo> bouncedRecipientInfoList;
        private String bounceSenderArn;

        private BuilderImpl() {
        }

        private BuilderImpl(SendBounceRequest model) {
            this.originalMessageId(model.originalMessageId);
            this.bounceSender(model.bounceSender);
            this.explanation(model.explanation);
            this.messageDsn(model.messageDsn);
            this.bouncedRecipientInfoList(model.bouncedRecipientInfoList);
            this.bounceSenderArn(model.bounceSenderArn);
        }

        public final String getOriginalMessageId() {
            return this.originalMessageId;
        }

        @Override
        public final Builder originalMessageId(String originalMessageId) {
            this.originalMessageId = originalMessageId;
            return this;
        }

        public final void setOriginalMessageId(String originalMessageId) {
            this.originalMessageId = originalMessageId;
        }

        public final String getBounceSender() {
            return this.bounceSender;
        }

        @Override
        public final Builder bounceSender(String bounceSender) {
            this.bounceSender = bounceSender;
            return this;
        }

        public final void setBounceSender(String bounceSender) {
            this.bounceSender = bounceSender;
        }

        public final String getExplanation() {
            return this.explanation;
        }

        @Override
        public final Builder explanation(String explanation) {
            this.explanation = explanation;
            return this;
        }

        public final void setExplanation(String explanation) {
            this.explanation = explanation;
        }

        public final MessageDsn.Builder getMessageDsn() {
            return this.messageDsn != null ? this.messageDsn.toBuilder() : null;
        }

        @Override
        public final Builder messageDsn(MessageDsn messageDsn) {
            this.messageDsn = messageDsn;
            return this;
        }

        public final void setMessageDsn(MessageDsn.BuilderImpl messageDsn) {
            this.messageDsn = messageDsn != null ? messageDsn.build() : null;
        }

        public final Collection<BouncedRecipientInfo.Builder> getBouncedRecipientInfoList() {
            return this.bouncedRecipientInfoList != null ? (Collection)this.bouncedRecipientInfoList.stream().map(BouncedRecipientInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder bouncedRecipientInfoList(Collection<BouncedRecipientInfo> bouncedRecipientInfoList) {
            this.bouncedRecipientInfoList = BouncedRecipientInfoListCopier.copy(bouncedRecipientInfoList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bouncedRecipientInfoList(BouncedRecipientInfo ... bouncedRecipientInfoList) {
            this.bouncedRecipientInfoList(Arrays.asList(bouncedRecipientInfoList));
            return this;
        }

        public final void setBouncedRecipientInfoList(Collection<BouncedRecipientInfo.BuilderImpl> bouncedRecipientInfoList) {
            this.bouncedRecipientInfoList = BouncedRecipientInfoListCopier.copyFromBuilder(bouncedRecipientInfoList);
        }

        public final String getBounceSenderArn() {
            return this.bounceSenderArn;
        }

        @Override
        public final Builder bounceSenderArn(String bounceSenderArn) {
            this.bounceSenderArn = bounceSenderArn;
            return this;
        }

        public final void setBounceSenderArn(String bounceSenderArn) {
            this.bounceSenderArn = bounceSenderArn;
        }

        public SendBounceRequest build() {
            return new SendBounceRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SendBounceRequest> {
        public Builder originalMessageId(String var1);

        public Builder bounceSender(String var1);

        public Builder explanation(String var1);

        public Builder messageDsn(MessageDsn var1);

        public Builder bouncedRecipientInfoList(Collection<BouncedRecipientInfo> var1);

        public Builder bouncedRecipientInfoList(BouncedRecipientInfo ... var1);

        public Builder bounceSenderArn(String var1);
    }
}

