/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Optional;
import software.amazon.awssdk.services.ses.model.SNSActionEncoding;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SNSAction
implements ToCopyableBuilder<Builder, SNSAction> {
    private final String topicArn;
    private final String encoding;

    private SNSAction(BuilderImpl builder) {
        this.topicArn = builder.topicArn;
        this.encoding = builder.encoding;
    }

    public String topicArn() {
        return this.topicArn;
    }

    public SNSActionEncoding encoding() {
        return SNSActionEncoding.fromValue(this.encoding);
    }

    public String encodingString() {
        return this.encoding;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.topicArn() == null ? 0 : this.topicArn().hashCode());
        hashCode = 31 * hashCode + (this.encodingString() == null ? 0 : this.encodingString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SNSAction)) {
            return false;
        }
        SNSAction other = (SNSAction)obj;
        if (other.topicArn() == null ^ this.topicArn() == null) {
            return false;
        }
        if (other.topicArn() != null && !other.topicArn().equals(this.topicArn())) {
            return false;
        }
        if (other.encodingString() == null ^ this.encodingString() == null) {
            return false;
        }
        return other.encodingString() == null || other.encodingString().equals(this.encodingString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.topicArn() != null) {
            sb.append("TopicArn: ").append(this.topicArn()).append(",");
        }
        if (this.encodingString() != null) {
            sb.append("Encoding: ").append(this.encodingString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TopicArn": {
                return Optional.of(clazz.cast(this.topicArn()));
            }
            case "Encoding": {
                return Optional.of(clazz.cast(this.encodingString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String topicArn;
        private String encoding;

        private BuilderImpl() {
        }

        private BuilderImpl(SNSAction model) {
            this.topicArn(model.topicArn);
            this.encoding(model.encoding);
        }

        public final String getTopicArn() {
            return this.topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        public final String getEncoding() {
            return this.encoding;
        }

        @Override
        public final Builder encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        @Override
        public final Builder encoding(SNSActionEncoding encoding) {
            this.encoding(encoding.toString());
            return this;
        }

        public final void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public SNSAction build() {
            return new SNSAction(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SNSAction> {
        public Builder topicArn(String var1);

        public Builder encoding(String var1);

        public Builder encoding(SNSActionEncoding var1);
    }
}

