/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ses.model.ExtensionField;
import software.amazon.awssdk.services.ses.model.ExtensionFieldListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MessageDsn
implements ToCopyableBuilder<Builder, MessageDsn> {
    private final String reportingMta;
    private final Instant arrivalDate;
    private final List<ExtensionField> extensionFields;

    private MessageDsn(BuilderImpl builder) {
        this.reportingMta = builder.reportingMta;
        this.arrivalDate = builder.arrivalDate;
        this.extensionFields = builder.extensionFields;
    }

    public String reportingMta() {
        return this.reportingMta;
    }

    public Instant arrivalDate() {
        return this.arrivalDate;
    }

    public List<ExtensionField> extensionFields() {
        return this.extensionFields;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.reportingMta() == null ? 0 : this.reportingMta().hashCode());
        hashCode = 31 * hashCode + (this.arrivalDate() == null ? 0 : this.arrivalDate().hashCode());
        hashCode = 31 * hashCode + (this.extensionFields() == null ? 0 : this.extensionFields().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageDsn)) {
            return false;
        }
        MessageDsn other = (MessageDsn)obj;
        if (other.reportingMta() == null ^ this.reportingMta() == null) {
            return false;
        }
        if (other.reportingMta() != null && !other.reportingMta().equals(this.reportingMta())) {
            return false;
        }
        if (other.arrivalDate() == null ^ this.arrivalDate() == null) {
            return false;
        }
        if (other.arrivalDate() != null && !other.arrivalDate().equals(this.arrivalDate())) {
            return false;
        }
        if (other.extensionFields() == null ^ this.extensionFields() == null) {
            return false;
        }
        return other.extensionFields() == null || other.extensionFields().equals(this.extensionFields());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.reportingMta() != null) {
            sb.append("ReportingMta: ").append(this.reportingMta()).append(",");
        }
        if (this.arrivalDate() != null) {
            sb.append("ArrivalDate: ").append(this.arrivalDate()).append(",");
        }
        if (this.extensionFields() != null) {
            sb.append("ExtensionFields: ").append(this.extensionFields()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReportingMta": {
                return Optional.of(clazz.cast(this.reportingMta()));
            }
            case "ArrivalDate": {
                return Optional.of(clazz.cast(this.arrivalDate()));
            }
            case "ExtensionFields": {
                return Optional.of(clazz.cast(this.extensionFields()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String reportingMta;
        private Instant arrivalDate;
        private List<ExtensionField> extensionFields;

        private BuilderImpl() {
        }

        private BuilderImpl(MessageDsn model) {
            this.reportingMta(model.reportingMta);
            this.arrivalDate(model.arrivalDate);
            this.extensionFields(model.extensionFields);
        }

        public final String getReportingMta() {
            return this.reportingMta;
        }

        @Override
        public final Builder reportingMta(String reportingMta) {
            this.reportingMta = reportingMta;
            return this;
        }

        public final void setReportingMta(String reportingMta) {
            this.reportingMta = reportingMta;
        }

        public final Instant getArrivalDate() {
            return this.arrivalDate;
        }

        @Override
        public final Builder arrivalDate(Instant arrivalDate) {
            this.arrivalDate = arrivalDate;
            return this;
        }

        public final void setArrivalDate(Instant arrivalDate) {
            this.arrivalDate = arrivalDate;
        }

        public final Collection<ExtensionField.Builder> getExtensionFields() {
            return this.extensionFields != null ? (Collection)this.extensionFields.stream().map(ExtensionField::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder extensionFields(Collection<ExtensionField> extensionFields) {
            this.extensionFields = ExtensionFieldListCopier.copy(extensionFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extensionFields(ExtensionField ... extensionFields) {
            this.extensionFields(Arrays.asList(extensionFields));
            return this;
        }

        public final void setExtensionFields(Collection<ExtensionField.BuilderImpl> extensionFields) {
            this.extensionFields = ExtensionFieldListCopier.copyFromBuilder(extensionFields);
        }

        public MessageDsn build() {
            return new MessageDsn(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MessageDsn> {
        public Builder reportingMta(String var1);

        public Builder arrivalDate(Instant var1);

        public Builder extensionFields(Collection<ExtensionField> var1);

        public Builder extensionFields(ExtensionField ... var1);
    }
}

