/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ses.model.IdentityVerificationAttributes;
import software.amazon.awssdk.services.ses.model.VerificationAttributesCopier;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetIdentityVerificationAttributesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetIdentityVerificationAttributesResponse> {
    private final Map<String, IdentityVerificationAttributes> verificationAttributes;

    private GetIdentityVerificationAttributesResponse(BuilderImpl builder) {
        this.verificationAttributes = builder.verificationAttributes;
    }

    public Map<String, IdentityVerificationAttributes> verificationAttributes() {
        return this.verificationAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.verificationAttributes() == null ? 0 : this.verificationAttributes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdentityVerificationAttributesResponse)) {
            return false;
        }
        GetIdentityVerificationAttributesResponse other = (GetIdentityVerificationAttributesResponse)((Object)obj);
        if (other.verificationAttributes() == null ^ this.verificationAttributes() == null) {
            return false;
        }
        return other.verificationAttributes() == null || other.verificationAttributes().equals(this.verificationAttributes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.verificationAttributes() != null) {
            sb.append("VerificationAttributes: ").append(this.verificationAttributes()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VerificationAttributes": {
                return Optional.of(clazz.cast(this.verificationAttributes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, IdentityVerificationAttributes> verificationAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdentityVerificationAttributesResponse model) {
            this.verificationAttributes(model.verificationAttributes);
        }

        public final Map<String, IdentityVerificationAttributes.Builder> getVerificationAttributes() {
            return this.verificationAttributes != null ? CollectionUtils.mapValues(this.verificationAttributes, IdentityVerificationAttributes::toBuilder) : null;
        }

        @Override
        public final Builder verificationAttributes(Map<String, IdentityVerificationAttributes> verificationAttributes) {
            this.verificationAttributes = VerificationAttributesCopier.copy(verificationAttributes);
            return this;
        }

        public final void setVerificationAttributes(Map<String, IdentityVerificationAttributes.BuilderImpl> verificationAttributes) {
            this.verificationAttributes = VerificationAttributesCopier.copyFromBuilder(verificationAttributes);
        }

        public GetIdentityVerificationAttributesResponse build() {
            return new GetIdentityVerificationAttributesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetIdentityVerificationAttributesResponse> {
        public Builder verificationAttributes(Map<String, IdentityVerificationAttributes> var1);
    }
}

