/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ses.model.PolicyNameListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetIdentityPoliciesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetIdentityPoliciesRequest> {
    private final String identity;
    private final List<String> policyNames;

    private GetIdentityPoliciesRequest(BuilderImpl builder) {
        this.identity = builder.identity;
        this.policyNames = builder.policyNames;
    }

    public String identity() {
        return this.identity;
    }

    public List<String> policyNames() {
        return this.policyNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.identity() == null ? 0 : this.identity().hashCode());
        hashCode = 31 * hashCode + (this.policyNames() == null ? 0 : this.policyNames().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdentityPoliciesRequest)) {
            return false;
        }
        GetIdentityPoliciesRequest other = (GetIdentityPoliciesRequest)((Object)obj);
        if (other.identity() == null ^ this.identity() == null) {
            return false;
        }
        if (other.identity() != null && !other.identity().equals(this.identity())) {
            return false;
        }
        if (other.policyNames() == null ^ this.policyNames() == null) {
            return false;
        }
        return other.policyNames() == null || other.policyNames().equals(this.policyNames());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.identity() != null) {
            sb.append("Identity: ").append(this.identity()).append(",");
        }
        if (this.policyNames() != null) {
            sb.append("PolicyNames: ").append(this.policyNames()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Identity": {
                return Optional.of(clazz.cast(this.identity()));
            }
            case "PolicyNames": {
                return Optional.of(clazz.cast(this.policyNames()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String identity;
        private List<String> policyNames;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdentityPoliciesRequest model) {
            this.identity(model.identity);
            this.policyNames(model.policyNames);
        }

        public final String getIdentity() {
            return this.identity;
        }

        @Override
        public final Builder identity(String identity) {
            this.identity = identity;
            return this;
        }

        public final void setIdentity(String identity) {
            this.identity = identity;
        }

        public final Collection<String> getPolicyNames() {
            return this.policyNames;
        }

        @Override
        public final Builder policyNames(Collection<String> policyNames) {
            this.policyNames = PolicyNameListCopier.copy(policyNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyNames(String ... policyNames) {
            this.policyNames(Arrays.asList(policyNames));
            return this;
        }

        public final void setPolicyNames(Collection<String> policyNames) {
            this.policyNames = PolicyNameListCopier.copy(policyNames);
        }

        public GetIdentityPoliciesRequest build() {
            return new GetIdentityPoliciesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetIdentityPoliciesRequest> {
        public Builder identity(String var1);

        public Builder policyNames(Collection<String> var1);

        public Builder policyNames(String ... var1);
    }
}

