/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.services.ses.model.AddressListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Destination
implements ToCopyableBuilder<Builder, Destination> {
    private final List<String> toAddresses;
    private final List<String> ccAddresses;
    private final List<String> bccAddresses;

    private Destination(BuilderImpl builder) {
        this.toAddresses = builder.toAddresses;
        this.ccAddresses = builder.ccAddresses;
        this.bccAddresses = builder.bccAddresses;
    }

    public List<String> toAddresses() {
        return this.toAddresses;
    }

    public List<String> ccAddresses() {
        return this.ccAddresses;
    }

    public List<String> bccAddresses() {
        return this.bccAddresses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.toAddresses() == null ? 0 : this.toAddresses().hashCode());
        hashCode = 31 * hashCode + (this.ccAddresses() == null ? 0 : this.ccAddresses().hashCode());
        hashCode = 31 * hashCode + (this.bccAddresses() == null ? 0 : this.bccAddresses().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Destination)) {
            return false;
        }
        Destination other = (Destination)obj;
        if (other.toAddresses() == null ^ this.toAddresses() == null) {
            return false;
        }
        if (other.toAddresses() != null && !other.toAddresses().equals(this.toAddresses())) {
            return false;
        }
        if (other.ccAddresses() == null ^ this.ccAddresses() == null) {
            return false;
        }
        if (other.ccAddresses() != null && !other.ccAddresses().equals(this.ccAddresses())) {
            return false;
        }
        if (other.bccAddresses() == null ^ this.bccAddresses() == null) {
            return false;
        }
        return other.bccAddresses() == null || other.bccAddresses().equals(this.bccAddresses());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.toAddresses() != null) {
            sb.append("ToAddresses: ").append(this.toAddresses()).append(",");
        }
        if (this.ccAddresses() != null) {
            sb.append("CcAddresses: ").append(this.ccAddresses()).append(",");
        }
        if (this.bccAddresses() != null) {
            sb.append("BccAddresses: ").append(this.bccAddresses()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ToAddresses": {
                return Optional.of(clazz.cast(this.toAddresses()));
            }
            case "CcAddresses": {
                return Optional.of(clazz.cast(this.ccAddresses()));
            }
            case "BccAddresses": {
                return Optional.of(clazz.cast(this.bccAddresses()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> toAddresses;
        private List<String> ccAddresses;
        private List<String> bccAddresses;

        private BuilderImpl() {
        }

        private BuilderImpl(Destination model) {
            this.toAddresses(model.toAddresses);
            this.ccAddresses(model.ccAddresses);
            this.bccAddresses(model.bccAddresses);
        }

        public final Collection<String> getToAddresses() {
            return this.toAddresses;
        }

        @Override
        public final Builder toAddresses(Collection<String> toAddresses) {
            this.toAddresses = AddressListCopier.copy(toAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder toAddresses(String ... toAddresses) {
            this.toAddresses(Arrays.asList(toAddresses));
            return this;
        }

        public final void setToAddresses(Collection<String> toAddresses) {
            this.toAddresses = AddressListCopier.copy(toAddresses);
        }

        public final Collection<String> getCcAddresses() {
            return this.ccAddresses;
        }

        @Override
        public final Builder ccAddresses(Collection<String> ccAddresses) {
            this.ccAddresses = AddressListCopier.copy(ccAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ccAddresses(String ... ccAddresses) {
            this.ccAddresses(Arrays.asList(ccAddresses));
            return this;
        }

        public final void setCcAddresses(Collection<String> ccAddresses) {
            this.ccAddresses = AddressListCopier.copy(ccAddresses);
        }

        public final Collection<String> getBccAddresses() {
            return this.bccAddresses;
        }

        @Override
        public final Builder bccAddresses(Collection<String> bccAddresses) {
            this.bccAddresses = AddressListCopier.copy(bccAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bccAddresses(String ... bccAddresses) {
            this.bccAddresses(Arrays.asList(bccAddresses));
            return this;
        }

        public final void setBccAddresses(Collection<String> bccAddresses) {
            this.bccAddresses = AddressListCopier.copy(bccAddresses);
        }

        public Destination build() {
            return new Destination(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Destination> {
        public Builder toAddresses(Collection<String> var1);

        public Builder toAddresses(String ... var1);

        public Builder ccAddresses(Collection<String> var1);

        public Builder ccAddresses(String ... var1);

        public Builder bccAddresses(Collection<String> var1);

        public Builder bccAddresses(String ... var1);
    }
}

