/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Optional;
import software.amazon.awssdk.services.ses.model.DimensionValueSource;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CloudWatchDimensionConfiguration
implements ToCopyableBuilder<Builder, CloudWatchDimensionConfiguration> {
    private final String dimensionName;
    private final String dimensionValueSource;
    private final String defaultDimensionValue;

    private CloudWatchDimensionConfiguration(BuilderImpl builder) {
        this.dimensionName = builder.dimensionName;
        this.dimensionValueSource = builder.dimensionValueSource;
        this.defaultDimensionValue = builder.defaultDimensionValue;
    }

    public String dimensionName() {
        return this.dimensionName;
    }

    public DimensionValueSource dimensionValueSource() {
        return DimensionValueSource.fromValue(this.dimensionValueSource);
    }

    public String dimensionValueSourceString() {
        return this.dimensionValueSource;
    }

    public String defaultDimensionValue() {
        return this.defaultDimensionValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.dimensionName() == null ? 0 : this.dimensionName().hashCode());
        hashCode = 31 * hashCode + (this.dimensionValueSourceString() == null ? 0 : this.dimensionValueSourceString().hashCode());
        hashCode = 31 * hashCode + (this.defaultDimensionValue() == null ? 0 : this.defaultDimensionValue().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchDimensionConfiguration)) {
            return false;
        }
        CloudWatchDimensionConfiguration other = (CloudWatchDimensionConfiguration)obj;
        if (other.dimensionName() == null ^ this.dimensionName() == null) {
            return false;
        }
        if (other.dimensionName() != null && !other.dimensionName().equals(this.dimensionName())) {
            return false;
        }
        if (other.dimensionValueSourceString() == null ^ this.dimensionValueSourceString() == null) {
            return false;
        }
        if (other.dimensionValueSourceString() != null && !other.dimensionValueSourceString().equals(this.dimensionValueSourceString())) {
            return false;
        }
        if (other.defaultDimensionValue() == null ^ this.defaultDimensionValue() == null) {
            return false;
        }
        return other.defaultDimensionValue() == null || other.defaultDimensionValue().equals(this.defaultDimensionValue());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.dimensionName() != null) {
            sb.append("DimensionName: ").append(this.dimensionName()).append(",");
        }
        if (this.dimensionValueSourceString() != null) {
            sb.append("DimensionValueSource: ").append(this.dimensionValueSourceString()).append(",");
        }
        if (this.defaultDimensionValue() != null) {
            sb.append("DefaultDimensionValue: ").append(this.defaultDimensionValue()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DimensionName": {
                return Optional.of(clazz.cast(this.dimensionName()));
            }
            case "DimensionValueSource": {
                return Optional.of(clazz.cast(this.dimensionValueSourceString()));
            }
            case "DefaultDimensionValue": {
                return Optional.of(clazz.cast(this.defaultDimensionValue()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String dimensionName;
        private String dimensionValueSource;
        private String defaultDimensionValue;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchDimensionConfiguration model) {
            this.dimensionName(model.dimensionName);
            this.dimensionValueSource(model.dimensionValueSource);
            this.defaultDimensionValue(model.defaultDimensionValue);
        }

        public final String getDimensionName() {
            return this.dimensionName;
        }

        @Override
        public final Builder dimensionName(String dimensionName) {
            this.dimensionName = dimensionName;
            return this;
        }

        public final void setDimensionName(String dimensionName) {
            this.dimensionName = dimensionName;
        }

        public final String getDimensionValueSource() {
            return this.dimensionValueSource;
        }

        @Override
        public final Builder dimensionValueSource(String dimensionValueSource) {
            this.dimensionValueSource = dimensionValueSource;
            return this;
        }

        @Override
        public final Builder dimensionValueSource(DimensionValueSource dimensionValueSource) {
            this.dimensionValueSource(dimensionValueSource.toString());
            return this;
        }

        public final void setDimensionValueSource(String dimensionValueSource) {
            this.dimensionValueSource = dimensionValueSource;
        }

        public final String getDefaultDimensionValue() {
            return this.defaultDimensionValue;
        }

        @Override
        public final Builder defaultDimensionValue(String defaultDimensionValue) {
            this.defaultDimensionValue = defaultDimensionValue;
            return this;
        }

        public final void setDefaultDimensionValue(String defaultDimensionValue) {
            this.defaultDimensionValue = defaultDimensionValue;
        }

        public CloudWatchDimensionConfiguration build() {
            return new CloudWatchDimensionConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CloudWatchDimensionConfiguration> {
        public Builder dimensionName(String var1);

        public Builder dimensionValueSource(String var1);

        public Builder dimensionValueSource(DimensionValueSource var1);

        public Builder defaultDimensionValue(String var1);
    }
}

