/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ses.model.Body;
import software.amazon.awssdk.services.ses.model.Content;
import software.amazon.awssdk.services.ses.model.Destination;
import software.amazon.awssdk.services.ses.model.Message;
import software.amazon.awssdk.services.ses.model.MessageTag;
import software.amazon.awssdk.services.ses.model.SendEmailRequest;
import software.amazon.awssdk.util.StringUtils;

public class SendEmailRequestMarshaller
implements Marshaller<Request<SendEmailRequest>, SendEmailRequest> {
    /*
     * WARNING - void declaration
     */
    public Request<SendEmailRequest> marshall(SendEmailRequest sendEmailRequest) {
        List<MessageTag> tagsList;
        List<String> replyToAddressesList;
        Message message;
        Destination destination;
        if (sendEmailRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)sendEmailRequest, "SESClient");
        request.addParameter("Action", "SendEmail");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (sendEmailRequest.source() != null) {
            request.addParameter("Source", StringUtils.fromString((String)sendEmailRequest.source()));
        }
        if ((destination = sendEmailRequest.destination()) != null) {
            List<String> bccAddressesList;
            List<String> ccAddressesList;
            List<String> toAddressesList = destination.toAddresses();
            if (toAddressesList != null) {
                if (!toAddressesList.isEmpty()) {
                    int toAddressesListIndex = 1;
                    for (String string : toAddressesList) {
                        if (string != null) {
                            request.addParameter("Destination.ToAddresses.member." + toAddressesListIndex, StringUtils.fromString((String)string));
                        }
                        ++toAddressesListIndex;
                    }
                } else {
                    request.addParameter("Destination.ToAddresses", "");
                }
            }
            if ((ccAddressesList = destination.ccAddresses()) != null) {
                if (!ccAddressesList.isEmpty()) {
                    int ccAddressesListIndex = 1;
                    for (String string : ccAddressesList) {
                        if (string != null) {
                            request.addParameter("Destination.CcAddresses.member." + ccAddressesListIndex, StringUtils.fromString((String)string));
                        }
                        ++ccAddressesListIndex;
                    }
                } else {
                    request.addParameter("Destination.CcAddresses", "");
                }
            }
            if ((bccAddressesList = destination.bccAddresses()) != null) {
                if (!bccAddressesList.isEmpty()) {
                    boolean bl = true;
                    for (String bccAddressesListValue : bccAddressesList) {
                        void var7_15;
                        if (bccAddressesListValue != null) {
                            request.addParameter("Destination.BccAddresses.member." + (int)var7_15, StringUtils.fromString((String)bccAddressesListValue));
                        }
                        ++var7_15;
                    }
                } else {
                    request.addParameter("Destination.BccAddresses", "");
                }
            }
        }
        if ((message = sendEmailRequest.message()) != null) {
            Body body;
            Content subject = message.subject();
            if (subject != null) {
                if (subject.data() != null) {
                    request.addParameter("Message.Subject.Data", StringUtils.fromString((String)subject.data()));
                }
                if (subject.charset() != null) {
                    request.addParameter("Message.Subject.Charset", StringUtils.fromString((String)subject.charset()));
                }
            }
            if ((body = message.body()) != null) {
                Content content;
                Content content2 = body.text();
                if (content2 != null) {
                    if (content2.data() != null) {
                        request.addParameter("Message.Body.Text.Data", StringUtils.fromString((String)content2.data()));
                    }
                    if (content2.charset() != null) {
                        request.addParameter("Message.Body.Text.Charset", StringUtils.fromString((String)content2.charset()));
                    }
                }
                if ((content = body.html()) != null) {
                    if (content.data() != null) {
                        request.addParameter("Message.Body.Html.Data", StringUtils.fromString((String)content.data()));
                    }
                    if (content.charset() != null) {
                        request.addParameter("Message.Body.Html.Charset", StringUtils.fromString((String)content.charset()));
                    }
                }
            }
        }
        if ((replyToAddressesList = sendEmailRequest.replyToAddresses()) != null) {
            if (!replyToAddressesList.isEmpty()) {
                int replyToAddressesListIndex = 1;
                for (String string : replyToAddressesList) {
                    if (string != null) {
                        request.addParameter("ReplyToAddresses.member." + replyToAddressesListIndex, StringUtils.fromString((String)string));
                    }
                    ++replyToAddressesListIndex;
                }
            } else {
                request.addParameter("ReplyToAddresses", "");
            }
        }
        if (sendEmailRequest.returnPath() != null) {
            request.addParameter("ReturnPath", StringUtils.fromString((String)sendEmailRequest.returnPath()));
        }
        if (sendEmailRequest.sourceArn() != null) {
            request.addParameter("SourceArn", StringUtils.fromString((String)sendEmailRequest.sourceArn()));
        }
        if (sendEmailRequest.returnPathArn() != null) {
            request.addParameter("ReturnPathArn", StringUtils.fromString((String)sendEmailRequest.returnPathArn()));
        }
        if ((tagsList = sendEmailRequest.tags()) != null) {
            if (!tagsList.isEmpty()) {
                boolean bl = true;
                for (MessageTag tagsListValue : tagsList) {
                    void var7_19;
                    if (tagsListValue.name() != null) {
                        request.addParameter("Tags.member." + (int)var7_19 + ".Name", StringUtils.fromString((String)tagsListValue.name()));
                    }
                    if (tagsListValue.value() != null) {
                        request.addParameter("Tags.member." + (int)var7_19 + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                    }
                    ++var7_19;
                }
            } else {
                request.addParameter("Tags", "");
            }
        }
        if (sendEmailRequest.configurationSetName() != null) {
            request.addParameter("ConfigurationSetName", StringUtils.fromString((String)sendEmailRequest.configurationSetName()));
        }
        return request;
    }
}

