/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ses.model.ListIdentitiesResponse;

public class ListIdentitiesResponseUnmarshaller
implements Unmarshaller<ListIdentitiesResponse, StaxUnmarshallerContext> {
    private static final ListIdentitiesResponseUnmarshaller INSTANCE = new ListIdentitiesResponseUnmarshaller();

    public ListIdentitiesResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        ListIdentitiesResponse.Builder listIdentitiesResponse;
        block6: {
            listIdentitiesResponse = ListIdentitiesResponse.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                targetDepth += 2;
            }
            ArrayList<String> identities = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    listIdentitiesResponse.identities(identities);
                    break block6;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Identities", targetDepth)) {
                        identities = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("Identities/member", targetDepth)) {
                        identities.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("NextToken", targetDepth)) continue;
                    listIdentitiesResponse.nextToken(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            listIdentitiesResponse.identities(identities);
        }
        return (ListIdentitiesResponse)((Object)listIdentitiesResponse.build());
    }

    public static ListIdentitiesResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}

