/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ses.model.DescribeConfigurationSetRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeConfigurationSetRequestMarshaller
implements Marshaller<Request<DescribeConfigurationSetRequest>, DescribeConfigurationSetRequest> {
    public Request<DescribeConfigurationSetRequest> marshall(DescribeConfigurationSetRequest describeConfigurationSetRequest) {
        List<String> configurationSetAttributeNamesList;
        if (describeConfigurationSetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeConfigurationSetRequest, "SESClient");
        request.addParameter("Action", "DescribeConfigurationSet");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeConfigurationSetRequest.configurationSetName() != null) {
            request.addParameter("ConfigurationSetName", StringUtils.fromString((String)describeConfigurationSetRequest.configurationSetName()));
        }
        if ((configurationSetAttributeNamesList = describeConfigurationSetRequest.configurationSetAttributeNames()) != null) {
            if (!configurationSetAttributeNamesList.isEmpty()) {
                int configurationSetAttributeNamesListIndex = 1;
                for (String configurationSetAttributeNamesListValue : configurationSetAttributeNamesList) {
                    if (configurationSetAttributeNamesListValue != null) {
                        request.addParameter("ConfigurationSetAttributeNames.member." + configurationSetAttributeNamesListIndex, StringUtils.fromString((String)configurationSetAttributeNamesListValue));
                    }
                    ++configurationSetAttributeNamesListIndex;
                }
            } else {
                request.addParameter("ConfigurationSetAttributeNames", "");
            }
        }
        return request;
    }
}

