/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import software.amazon.awssdk.services.ses.model.SESException;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InvalidFirehoseDestinationException
extends SESException
implements ToCopyableBuilder<Builder, InvalidFirehoseDestinationException> {
    private final String configurationSetName;
    private final String eventDestinationName;

    private InvalidFirehoseDestinationException(BuilderImpl builder) {
        super(builder.message);
        this.configurationSetName = builder.configurationSetName;
        this.eventDestinationName = builder.eventDestinationName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public String configurationSetName() {
        return this.configurationSetName;
    }

    public String eventDestinationName() {
        return this.eventDestinationName;
    }

    private static final class BuilderImpl
    implements Builder {
        private String configurationSetName;
        private String eventDestinationName;
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(InvalidFirehoseDestinationException model) {
            this.setConfigurationSetName(model.configurationSetName);
            this.setEventDestinationName(model.eventDestinationName);
            this.message = model.getMessage();
        }

        public final String getConfigurationSetName() {
            return this.configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        public final String getEventDestinationName() {
            return this.eventDestinationName;
        }

        @Override
        public final Builder eventDestinationName(String eventDestinationName) {
            this.eventDestinationName = eventDestinationName;
            return this;
        }

        public final void setEventDestinationName(String eventDestinationName) {
            this.eventDestinationName = eventDestinationName;
        }

        public String getMessage() {
            return this.message;
        }

        public String message() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public InvalidFirehoseDestinationException build() {
            return new InvalidFirehoseDestinationException(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InvalidFirehoseDestinationException> {
        public Builder configurationSetName(String var1);

        public Builder eventDestinationName(String var1);

        public Builder message(String var1);
    }
}

