/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.time.Instant;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SendDataPoint
implements ToCopyableBuilder<Builder, SendDataPoint> {
    private final Instant timestamp;
    private final Long deliveryAttempts;
    private final Long bounces;
    private final Long complaints;
    private final Long rejects;

    private SendDataPoint(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.deliveryAttempts = builder.deliveryAttempts;
        this.bounces = builder.bounces;
        this.complaints = builder.complaints;
        this.rejects = builder.rejects;
    }

    public Instant timestamp() {
        return this.timestamp;
    }

    public Long deliveryAttempts() {
        return this.deliveryAttempts;
    }

    public Long bounces() {
        return this.bounces;
    }

    public Long complaints() {
        return this.complaints;
    }

    public Long rejects() {
        return this.rejects;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.timestamp() == null ? 0 : this.timestamp().hashCode());
        hashCode = 31 * hashCode + (this.deliveryAttempts() == null ? 0 : this.deliveryAttempts().hashCode());
        hashCode = 31 * hashCode + (this.bounces() == null ? 0 : this.bounces().hashCode());
        hashCode = 31 * hashCode + (this.complaints() == null ? 0 : this.complaints().hashCode());
        hashCode = 31 * hashCode + (this.rejects() == null ? 0 : this.rejects().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendDataPoint)) {
            return false;
        }
        SendDataPoint other = (SendDataPoint)obj;
        if (other.timestamp() == null ^ this.timestamp() == null) {
            return false;
        }
        if (other.timestamp() != null && !other.timestamp().equals(this.timestamp())) {
            return false;
        }
        if (other.deliveryAttempts() == null ^ this.deliveryAttempts() == null) {
            return false;
        }
        if (other.deliveryAttempts() != null && !other.deliveryAttempts().equals(this.deliveryAttempts())) {
            return false;
        }
        if (other.bounces() == null ^ this.bounces() == null) {
            return false;
        }
        if (other.bounces() != null && !other.bounces().equals(this.bounces())) {
            return false;
        }
        if (other.complaints() == null ^ this.complaints() == null) {
            return false;
        }
        if (other.complaints() != null && !other.complaints().equals(this.complaints())) {
            return false;
        }
        if (other.rejects() == null ^ this.rejects() == null) {
            return false;
        }
        return other.rejects() == null || other.rejects().equals(this.rejects());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.timestamp() != null) {
            sb.append("Timestamp: ").append(this.timestamp()).append(",");
        }
        if (this.deliveryAttempts() != null) {
            sb.append("DeliveryAttempts: ").append(this.deliveryAttempts()).append(",");
        }
        if (this.bounces() != null) {
            sb.append("Bounces: ").append(this.bounces()).append(",");
        }
        if (this.complaints() != null) {
            sb.append("Complaints: ").append(this.complaints()).append(",");
        }
        if (this.rejects() != null) {
            sb.append("Rejects: ").append(this.rejects()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Instant timestamp;
        private Long deliveryAttempts;
        private Long bounces;
        private Long complaints;
        private Long rejects;

        private BuilderImpl() {
        }

        private BuilderImpl(SendDataPoint model) {
            this.setTimestamp(model.timestamp);
            this.setDeliveryAttempts(model.deliveryAttempts);
            this.setBounces(model.bounces);
            this.setComplaints(model.complaints);
            this.setRejects(model.rejects);
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public final Long getDeliveryAttempts() {
            return this.deliveryAttempts;
        }

        @Override
        public final Builder deliveryAttempts(Long deliveryAttempts) {
            this.deliveryAttempts = deliveryAttempts;
            return this;
        }

        public final void setDeliveryAttempts(Long deliveryAttempts) {
            this.deliveryAttempts = deliveryAttempts;
        }

        public final Long getBounces() {
            return this.bounces;
        }

        @Override
        public final Builder bounces(Long bounces) {
            this.bounces = bounces;
            return this;
        }

        public final void setBounces(Long bounces) {
            this.bounces = bounces;
        }

        public final Long getComplaints() {
            return this.complaints;
        }

        @Override
        public final Builder complaints(Long complaints) {
            this.complaints = complaints;
            return this;
        }

        public final void setComplaints(Long complaints) {
            this.complaints = complaints;
        }

        public final Long getRejects() {
            return this.rejects;
        }

        @Override
        public final Builder rejects(Long rejects) {
            this.rejects = rejects;
            return this;
        }

        public final void setRejects(Long rejects) {
            this.rejects = rejects;
        }

        public SendDataPoint build() {
            return new SendDataPoint(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SendDataPoint> {
        public Builder timestamp(Instant var1);

        public Builder deliveryAttempts(Long var1);

        public Builder bounces(Long var1);

        public Builder complaints(Long var1);

        public Builder rejects(Long var1);
    }
}

