/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.ses.model.ReceiptRule;
import software.amazon.awssdk.services.ses.model.ReceiptRuleSetMetadata;
import software.amazon.awssdk.services.ses.model.ReceiptRulesListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeReceiptRuleSetResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeReceiptRuleSetResponse> {
    private final ReceiptRuleSetMetadata metadata;
    private final List<ReceiptRule> rules;

    private DescribeReceiptRuleSetResponse(BuilderImpl builder) {
        this.metadata = builder.metadata;
        this.rules = builder.rules;
    }

    public ReceiptRuleSetMetadata metadata() {
        return this.metadata;
    }

    public List<ReceiptRule> rules() {
        return this.rules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.metadata() == null ? 0 : this.metadata().hashCode());
        hashCode = 31 * hashCode + (this.rules() == null ? 0 : this.rules().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReceiptRuleSetResponse)) {
            return false;
        }
        DescribeReceiptRuleSetResponse other = (DescribeReceiptRuleSetResponse)((Object)obj);
        if (other.metadata() == null ^ this.metadata() == null) {
            return false;
        }
        if (other.metadata() != null && !other.metadata().equals(this.metadata())) {
            return false;
        }
        if (other.rules() == null ^ this.rules() == null) {
            return false;
        }
        return other.rules() == null || other.rules().equals(this.rules());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.metadata() != null) {
            sb.append("Metadata: ").append(this.metadata()).append(",");
        }
        if (this.rules() != null) {
            sb.append("Rules: ").append(this.rules()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private ReceiptRuleSetMetadata metadata;
        private List<ReceiptRule> rules;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReceiptRuleSetResponse model) {
            this.setMetadata(model.metadata);
            this.setRules(model.rules);
        }

        public final ReceiptRuleSetMetadata getMetadata() {
            return this.metadata;
        }

        @Override
        public final Builder metadata(ReceiptRuleSetMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final void setMetadata(ReceiptRuleSetMetadata metadata) {
            this.metadata = metadata;
        }

        public final Collection<ReceiptRule> getRules() {
            return this.rules;
        }

        @Override
        public final Builder rules(Collection<ReceiptRule> rules) {
            this.rules = ReceiptRulesListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(ReceiptRule ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        public final void setRules(Collection<ReceiptRule> rules) {
            this.rules = ReceiptRulesListCopier.copy(rules);
        }

        @SafeVarargs
        public final void setRules(ReceiptRule ... rules) {
            this.rules(Arrays.asList(rules));
        }

        public DescribeReceiptRuleSetResponse build() {
            return new DescribeReceiptRuleSetResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeReceiptRuleSetResponse> {
        public Builder metadata(ReceiptRuleSetMetadata var1);

        public Builder rules(Collection<ReceiptRule> var1);

        public Builder rules(ReceiptRule ... var1);
    }
}

