/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.ses.model.ConfigurationSet;
import software.amazon.awssdk.services.ses.model.EventDestination;
import software.amazon.awssdk.services.ses.model.EventDestinationsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeConfigurationSetResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeConfigurationSetResponse> {
    private final ConfigurationSet configurationSet;
    private final List<EventDestination> eventDestinations;

    private DescribeConfigurationSetResponse(BuilderImpl builder) {
        this.configurationSet = builder.configurationSet;
        this.eventDestinations = builder.eventDestinations;
    }

    public ConfigurationSet configurationSet() {
        return this.configurationSet;
    }

    public List<EventDestination> eventDestinations() {
        return this.eventDestinations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.configurationSet() == null ? 0 : this.configurationSet().hashCode());
        hashCode = 31 * hashCode + (this.eventDestinations() == null ? 0 : this.eventDestinations().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationSetResponse)) {
            return false;
        }
        DescribeConfigurationSetResponse other = (DescribeConfigurationSetResponse)((Object)obj);
        if (other.configurationSet() == null ^ this.configurationSet() == null) {
            return false;
        }
        if (other.configurationSet() != null && !other.configurationSet().equals(this.configurationSet())) {
            return false;
        }
        if (other.eventDestinations() == null ^ this.eventDestinations() == null) {
            return false;
        }
        return other.eventDestinations() == null || other.eventDestinations().equals(this.eventDestinations());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.configurationSet() != null) {
            sb.append("ConfigurationSet: ").append(this.configurationSet()).append(",");
        }
        if (this.eventDestinations() != null) {
            sb.append("EventDestinations: ").append(this.eventDestinations()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private ConfigurationSet configurationSet;
        private List<EventDestination> eventDestinations;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationSetResponse model) {
            this.setConfigurationSet(model.configurationSet);
            this.setEventDestinations(model.eventDestinations);
        }

        public final ConfigurationSet getConfigurationSet() {
            return this.configurationSet;
        }

        @Override
        public final Builder configurationSet(ConfigurationSet configurationSet) {
            this.configurationSet = configurationSet;
            return this;
        }

        public final void setConfigurationSet(ConfigurationSet configurationSet) {
            this.configurationSet = configurationSet;
        }

        public final Collection<EventDestination> getEventDestinations() {
            return this.eventDestinations;
        }

        @Override
        public final Builder eventDestinations(Collection<EventDestination> eventDestinations) {
            this.eventDestinations = EventDestinationsCopier.copy(eventDestinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventDestinations(EventDestination ... eventDestinations) {
            this.eventDestinations(Arrays.asList(eventDestinations));
            return this;
        }

        public final void setEventDestinations(Collection<EventDestination> eventDestinations) {
            this.eventDestinations = EventDestinationsCopier.copy(eventDestinations);
        }

        @SafeVarargs
        public final void setEventDestinations(EventDestination ... eventDestinations) {
            this.eventDestinations(Arrays.asList(eventDestinations));
        }

        public DescribeConfigurationSetResponse build() {
            return new DescribeConfigurationSetResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeConfigurationSetResponse> {
        public Builder configurationSet(ConfigurationSet var1);

        public Builder eventDestinations(Collection<EventDestination> var1);

        public Builder eventDestinations(EventDestination ... var1);
    }
}

