/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ses.model.SetIdentityNotificationTopicRequest;

public class SetIdentityNotificationTopicRequestMarshaller
implements Marshaller<Request<SetIdentityNotificationTopicRequest>, SetIdentityNotificationTopicRequest> {
    public Request<SetIdentityNotificationTopicRequest> marshall(SetIdentityNotificationTopicRequest setIdentityNotificationTopicRequest) {
        if (setIdentityNotificationTopicRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)setIdentityNotificationTopicRequest, "SesClient");
        request.addParameter("Action", "SetIdentityNotificationTopic");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (setIdentityNotificationTopicRequest.identity() != null) {
            request.addParameter("Identity", StringConversion.fromString((String)setIdentityNotificationTopicRequest.identity()));
        }
        if (setIdentityNotificationTopicRequest.notificationTypeAsString() != null) {
            request.addParameter("NotificationType", StringConversion.fromString((String)setIdentityNotificationTopicRequest.notificationTypeAsString()));
        }
        if (setIdentityNotificationTopicRequest.snsTopic() != null) {
            request.addParameter("SnsTopic", StringConversion.fromString((String)setIdentityNotificationTopicRequest.snsTopic()));
        }
        return request;
    }
}

