/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ses.model.CustomVerificationEmailTemplate;

public class CustomVerificationEmailTemplateUnmarshaller
implements Unmarshaller<CustomVerificationEmailTemplate, StaxUnmarshallerContext> {
    private static final CustomVerificationEmailTemplateUnmarshaller INSTANCE = new CustomVerificationEmailTemplateUnmarshaller();

    public CustomVerificationEmailTemplate unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        CustomVerificationEmailTemplate.Builder customVerificationEmailTemplate = CustomVerificationEmailTemplate.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("TemplateName", targetDepth)) {
                    customVerificationEmailTemplate.templateName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("FromEmailAddress", targetDepth)) {
                    customVerificationEmailTemplate.fromEmailAddress(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("TemplateSubject", targetDepth)) {
                    customVerificationEmailTemplate.templateSubject(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SuccessRedirectionURL", targetDepth)) {
                    customVerificationEmailTemplate.successRedirectionURL(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("FailureRedirectionURL", targetDepth)) continue;
                customVerificationEmailTemplate.failureRedirectionURL(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (CustomVerificationEmailTemplate)customVerificationEmailTemplate.build();
    }

    public static CustomVerificationEmailTemplateUnmarshaller getInstance() {
        return INSTANCE;
    }
}

