/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ses.model.CreateCustomVerificationEmailTemplateRequest;

public class CreateCustomVerificationEmailTemplateRequestMarshaller
implements Marshaller<Request<CreateCustomVerificationEmailTemplateRequest>, CreateCustomVerificationEmailTemplateRequest> {
    public Request<CreateCustomVerificationEmailTemplateRequest> marshall(CreateCustomVerificationEmailTemplateRequest createCustomVerificationEmailTemplateRequest) {
        if (createCustomVerificationEmailTemplateRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createCustomVerificationEmailTemplateRequest, "SesClient");
        request.addParameter("Action", "CreateCustomVerificationEmailTemplate");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createCustomVerificationEmailTemplateRequest.templateName() != null) {
            request.addParameter("TemplateName", StringConversion.fromString((String)createCustomVerificationEmailTemplateRequest.templateName()));
        }
        if (createCustomVerificationEmailTemplateRequest.fromEmailAddress() != null) {
            request.addParameter("FromEmailAddress", StringConversion.fromString((String)createCustomVerificationEmailTemplateRequest.fromEmailAddress()));
        }
        if (createCustomVerificationEmailTemplateRequest.templateSubject() != null) {
            request.addParameter("TemplateSubject", StringConversion.fromString((String)createCustomVerificationEmailTemplateRequest.templateSubject()));
        }
        if (createCustomVerificationEmailTemplateRequest.templateContent() != null) {
            request.addParameter("TemplateContent", StringConversion.fromString((String)createCustomVerificationEmailTemplateRequest.templateContent()));
        }
        if (createCustomVerificationEmailTemplateRequest.successRedirectionURL() != null) {
            request.addParameter("SuccessRedirectionURL", StringConversion.fromString((String)createCustomVerificationEmailTemplateRequest.successRedirectionURL()));
        }
        if (createCustomVerificationEmailTemplateRequest.failureRedirectionURL() != null) {
            request.addParameter("FailureRedirectionURL", StringConversion.fromString((String)createCustomVerificationEmailTemplateRequest.failureRedirectionURL()));
        }
        return request;
    }
}

