/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ses.model.CloudWatchDestination;
import software.amazon.awssdk.services.ses.model.CloudWatchDimensionConfiguration;
import software.amazon.awssdk.services.ses.model.CreateConfigurationSetEventDestinationRequest;
import software.amazon.awssdk.services.ses.model.EventDestination;
import software.amazon.awssdk.services.ses.model.KinesisFirehoseDestination;
import software.amazon.awssdk.services.ses.model.SNSDestination;

public class CreateConfigurationSetEventDestinationRequestMarshaller
implements Marshaller<Request<CreateConfigurationSetEventDestinationRequest>, CreateConfigurationSetEventDestinationRequest> {
    public Request<CreateConfigurationSetEventDestinationRequest> marshall(CreateConfigurationSetEventDestinationRequest createConfigurationSetEventDestinationRequest) {
        EventDestination eventDestination;
        if (createConfigurationSetEventDestinationRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createConfigurationSetEventDestinationRequest, "SesClient");
        request.addParameter("Action", "CreateConfigurationSetEventDestination");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createConfigurationSetEventDestinationRequest.configurationSetName() != null) {
            request.addParameter("ConfigurationSetName", StringConversion.fromString((String)createConfigurationSetEventDestinationRequest.configurationSetName()));
        }
        if ((eventDestination = createConfigurationSetEventDestinationRequest.eventDestination()) != null) {
            SNSDestination snsDestination;
            CloudWatchDestination cloudWatchDestination;
            if (eventDestination.name() != null) {
                request.addParameter("EventDestination.Name", StringConversion.fromString((String)eventDestination.name()));
            }
            if (eventDestination.enabled() != null) {
                request.addParameter("EventDestination.Enabled", StringConversion.fromBoolean((Boolean)eventDestination.enabled()));
            }
            if (eventDestination.matchingEventTypesAsStrings().isEmpty() && !(eventDestination.matchingEventTypesAsStrings() instanceof SdkAutoConstructList)) {
                request.addParameter("EventDestination.MatchingEventTypes", "");
            } else if (!eventDestination.matchingEventTypesAsStrings().isEmpty() && !(eventDestination.matchingEventTypesAsStrings() instanceof SdkAutoConstructList)) {
                List<String> matchingEventTypesList = eventDestination.matchingEventTypesAsStrings();
                int matchingEventTypesListIndex = 1;
                for (String matchingEventTypesListValue : matchingEventTypesList) {
                    if (matchingEventTypesListValue != null) {
                        request.addParameter("EventDestination.MatchingEventTypes.member." + matchingEventTypesListIndex, StringConversion.fromString((String)matchingEventTypesListValue));
                    }
                    ++matchingEventTypesListIndex;
                }
            }
            KinesisFirehoseDestination kinesisFirehoseDestination = eventDestination.kinesisFirehoseDestination();
            if (kinesisFirehoseDestination != null) {
                if (kinesisFirehoseDestination.iamRoleARN() != null) {
                    request.addParameter("EventDestination.KinesisFirehoseDestination.IAMRoleARN", StringConversion.fromString((String)kinesisFirehoseDestination.iamRoleARN()));
                }
                if (kinesisFirehoseDestination.deliveryStreamARN() != null) {
                    request.addParameter("EventDestination.KinesisFirehoseDestination.DeliveryStreamARN", StringConversion.fromString((String)kinesisFirehoseDestination.deliveryStreamARN()));
                }
            }
            if ((cloudWatchDestination = eventDestination.cloudWatchDestination()) != null) {
                if (cloudWatchDestination.dimensionConfigurations().isEmpty() && !(cloudWatchDestination.dimensionConfigurations() instanceof SdkAutoConstructList)) {
                    request.addParameter("EventDestination.CloudWatchDestination.DimensionConfigurations", "");
                } else if (!cloudWatchDestination.dimensionConfigurations().isEmpty() && !(cloudWatchDestination.dimensionConfigurations() instanceof SdkAutoConstructList)) {
                    List<CloudWatchDimensionConfiguration> dimensionConfigurationsList = cloudWatchDestination.dimensionConfigurations();
                    int dimensionConfigurationsListIndex = 1;
                    for (CloudWatchDimensionConfiguration dimensionConfigurationsListValue : dimensionConfigurationsList) {
                        if (dimensionConfigurationsListValue.dimensionName() != null) {
                            request.addParameter("EventDestination.CloudWatchDestination.DimensionConfigurations.member." + dimensionConfigurationsListIndex + ".DimensionName", StringConversion.fromString((String)dimensionConfigurationsListValue.dimensionName()));
                        }
                        if (dimensionConfigurationsListValue.dimensionValueSourceAsString() != null) {
                            request.addParameter("EventDestination.CloudWatchDestination.DimensionConfigurations.member." + dimensionConfigurationsListIndex + ".DimensionValueSource", StringConversion.fromString((String)dimensionConfigurationsListValue.dimensionValueSourceAsString()));
                        }
                        if (dimensionConfigurationsListValue.defaultDimensionValue() != null) {
                            request.addParameter("EventDestination.CloudWatchDestination.DimensionConfigurations.member." + dimensionConfigurationsListIndex + ".DefaultDimensionValue", StringConversion.fromString((String)dimensionConfigurationsListValue.defaultDimensionValue()));
                        }
                        ++dimensionConfigurationsListIndex;
                    }
                }
            }
            if ((snsDestination = eventDestination.snsDestination()) != null && snsDestination.topicARN() != null) {
                request.addParameter("EventDestination.SNSDestination.TopicARN", StringConversion.fromString((String)snsDestination.topicARN()));
            }
        }
        return request;
    }
}

