/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.ses.model.SesRequest;
import software.amazon.awssdk.services.ses.model.TrackingOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateConfigurationSetTrackingOptionsRequest
extends SesRequest
implements ToCopyableBuilder<Builder, UpdateConfigurationSetTrackingOptionsRequest> {
    private final String configurationSetName;
    private final TrackingOptions trackingOptions;

    private UpdateConfigurationSetTrackingOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.configurationSetName = builder.configurationSetName;
        this.trackingOptions = builder.trackingOptions;
    }

    public String configurationSetName() {
        return this.configurationSetName;
    }

    public TrackingOptions trackingOptions() {
        return this.trackingOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.trackingOptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConfigurationSetTrackingOptionsRequest)) {
            return false;
        }
        UpdateConfigurationSetTrackingOptionsRequest other = (UpdateConfigurationSetTrackingOptionsRequest)((Object)obj);
        return Objects.equals(this.configurationSetName(), other.configurationSetName()) && Objects.equals(this.trackingOptions(), other.trackingOptions());
    }

    public String toString() {
        return ToString.builder((String)"UpdateConfigurationSetTrackingOptionsRequest").add("ConfigurationSetName", (Object)this.configurationSetName()).add("TrackingOptions", (Object)this.trackingOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationSetName": {
                return Optional.ofNullable(clazz.cast(this.configurationSetName()));
            }
            case "TrackingOptions": {
                return Optional.ofNullable(clazz.cast(this.trackingOptions()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SesRequest.BuilderImpl
    implements Builder {
        private String configurationSetName;
        private TrackingOptions trackingOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConfigurationSetTrackingOptionsRequest model) {
            super(model);
            this.configurationSetName(model.configurationSetName);
            this.trackingOptions(model.trackingOptions);
        }

        public final String getConfigurationSetName() {
            return this.configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        public final TrackingOptions.Builder getTrackingOptions() {
            return this.trackingOptions != null ? this.trackingOptions.toBuilder() : null;
        }

        @Override
        public final Builder trackingOptions(TrackingOptions trackingOptions) {
            this.trackingOptions = trackingOptions;
            return this;
        }

        public final void setTrackingOptions(TrackingOptions.BuilderImpl trackingOptions) {
            this.trackingOptions = trackingOptions != null ? trackingOptions.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateConfigurationSetTrackingOptionsRequest build() {
            return new UpdateConfigurationSetTrackingOptionsRequest(this);
        }
    }

    public static interface Builder
    extends SesRequest.Builder,
    CopyableBuilder<Builder, UpdateConfigurationSetTrackingOptionsRequest> {
        public Builder configurationSetName(String var1);

        public Builder trackingOptions(TrackingOptions var1);

        default public Builder trackingOptions(Consumer<TrackingOptions.Builder> trackingOptions) {
            return this.trackingOptions((TrackingOptions)((TrackingOptions.Builder)TrackingOptions.builder().applyMutation(trackingOptions)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

