/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Template
implements ToCopyableBuilder<Builder, Template> {
    private final String templateName;
    private final String subjectPart;
    private final String textPart;
    private final String htmlPart;

    private Template(BuilderImpl builder) {
        this.templateName = builder.templateName;
        this.subjectPart = builder.subjectPart;
        this.textPart = builder.textPart;
        this.htmlPart = builder.htmlPart;
    }

    public String templateName() {
        return this.templateName;
    }

    public String subjectPart() {
        return this.subjectPart;
    }

    public String textPart() {
        return this.textPart;
    }

    public String htmlPart() {
        return this.htmlPart;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.subjectPart());
        hashCode = 31 * hashCode + Objects.hashCode(this.textPart());
        hashCode = 31 * hashCode + Objects.hashCode(this.htmlPart());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Template)) {
            return false;
        }
        Template other = (Template)obj;
        return Objects.equals(this.templateName(), other.templateName()) && Objects.equals(this.subjectPart(), other.subjectPart()) && Objects.equals(this.textPart(), other.textPart()) && Objects.equals(this.htmlPart(), other.htmlPart());
    }

    public String toString() {
        return ToString.builder((String)"Template").add("TemplateName", (Object)this.templateName()).add("SubjectPart", (Object)this.subjectPart()).add("TextPart", (Object)this.textPart()).add("HtmlPart", (Object)this.htmlPart()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TemplateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
            case "SubjectPart": {
                return Optional.ofNullable(clazz.cast(this.subjectPart()));
            }
            case "TextPart": {
                return Optional.ofNullable(clazz.cast(this.textPart()));
            }
            case "HtmlPart": {
                return Optional.ofNullable(clazz.cast(this.htmlPart()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String templateName;
        private String subjectPart;
        private String textPart;
        private String htmlPart;

        private BuilderImpl() {
        }

        private BuilderImpl(Template model) {
            this.templateName(model.templateName);
            this.subjectPart(model.subjectPart);
            this.textPart(model.textPart);
            this.htmlPart(model.htmlPart);
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public final String getSubjectPart() {
            return this.subjectPart;
        }

        @Override
        public final Builder subjectPart(String subjectPart) {
            this.subjectPart = subjectPart;
            return this;
        }

        public final void setSubjectPart(String subjectPart) {
            this.subjectPart = subjectPart;
        }

        public final String getTextPart() {
            return this.textPart;
        }

        @Override
        public final Builder textPart(String textPart) {
            this.textPart = textPart;
            return this;
        }

        public final void setTextPart(String textPart) {
            this.textPart = textPart;
        }

        public final String getHtmlPart() {
            return this.htmlPart;
        }

        @Override
        public final Builder htmlPart(String htmlPart) {
            this.htmlPart = htmlPart;
            return this;
        }

        public final void setHtmlPart(String htmlPart) {
            this.htmlPart = htmlPart;
        }

        public Template build() {
            return new Template(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Template> {
        public Builder templateName(String var1);

        public Builder subjectPart(String var1);

        public Builder textPart(String var1);

        public Builder htmlPart(String var1);
    }
}

