/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ses.model.CloudWatchDestination;
import software.amazon.awssdk.services.ses.model.EventType;
import software.amazon.awssdk.services.ses.model.EventTypesCopier;
import software.amazon.awssdk.services.ses.model.KinesisFirehoseDestination;
import software.amazon.awssdk.services.ses.model.SNSDestination;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventDestination
implements ToCopyableBuilder<Builder, EventDestination> {
    private final String name;
    private final Boolean enabled;
    private final List<String> matchingEventTypes;
    private final KinesisFirehoseDestination kinesisFirehoseDestination;
    private final CloudWatchDestination cloudWatchDestination;
    private final SNSDestination snsDestination;

    private EventDestination(BuilderImpl builder) {
        this.name = builder.name;
        this.enabled = builder.enabled;
        this.matchingEventTypes = builder.matchingEventTypes;
        this.kinesisFirehoseDestination = builder.kinesisFirehoseDestination;
        this.cloudWatchDestination = builder.cloudWatchDestination;
        this.snsDestination = builder.snsDestination;
    }

    public String name() {
        return this.name;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public List<EventType> matchingEventTypes() {
        return TypeConverter.convert(this.matchingEventTypes, EventType::fromValue);
    }

    public List<String> matchingEventTypesAsStrings() {
        return this.matchingEventTypes;
    }

    public KinesisFirehoseDestination kinesisFirehoseDestination() {
        return this.kinesisFirehoseDestination;
    }

    public CloudWatchDestination cloudWatchDestination() {
        return this.cloudWatchDestination;
    }

    public SNSDestination snsDestination() {
        return this.snsDestination;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.matchingEventTypesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisFirehoseDestination());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchDestination());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsDestination());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventDestination)) {
            return false;
        }
        EventDestination other = (EventDestination)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.matchingEventTypesAsStrings(), other.matchingEventTypesAsStrings()) && Objects.equals(this.kinesisFirehoseDestination(), other.kinesisFirehoseDestination()) && Objects.equals(this.cloudWatchDestination(), other.cloudWatchDestination()) && Objects.equals(this.snsDestination(), other.snsDestination());
    }

    public String toString() {
        return ToString.builder((String)"EventDestination").add("Name", (Object)this.name()).add("Enabled", (Object)this.enabled()).add("MatchingEventTypes", this.matchingEventTypesAsStrings()).add("KinesisFirehoseDestination", (Object)this.kinesisFirehoseDestination()).add("CloudWatchDestination", (Object)this.cloudWatchDestination()).add("SNSDestination", (Object)this.snsDestination()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "MatchingEventTypes": {
                return Optional.ofNullable(clazz.cast(this.matchingEventTypesAsStrings()));
            }
            case "KinesisFirehoseDestination": {
                return Optional.ofNullable(clazz.cast(this.kinesisFirehoseDestination()));
            }
            case "CloudWatchDestination": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchDestination()));
            }
            case "SNSDestination": {
                return Optional.ofNullable(clazz.cast(this.snsDestination()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Boolean enabled;
        private List<String> matchingEventTypes = DefaultSdkAutoConstructList.getInstance();
        private KinesisFirehoseDestination kinesisFirehoseDestination;
        private CloudWatchDestination cloudWatchDestination;
        private SNSDestination snsDestination;

        private BuilderImpl() {
        }

        private BuilderImpl(EventDestination model) {
            this.name(model.name);
            this.enabled(model.enabled);
            this.matchingEventTypesWithStrings(model.matchingEventTypes);
            this.kinesisFirehoseDestination(model.kinesisFirehoseDestination);
            this.cloudWatchDestination(model.cloudWatchDestination);
            this.snsDestination(model.snsDestination);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Collection<String> getMatchingEventTypes() {
            return this.matchingEventTypes;
        }

        @Override
        public final Builder matchingEventTypesWithStrings(Collection<String> matchingEventTypes) {
            this.matchingEventTypes = EventTypesCopier.copy(matchingEventTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchingEventTypesWithStrings(String ... matchingEventTypes) {
            this.matchingEventTypesWithStrings(Arrays.asList(matchingEventTypes));
            return this;
        }

        @Override
        public final Builder matchingEventTypes(Collection<EventType> matchingEventTypes) {
            this.matchingEventTypes = EventTypesCopier.copyEnumToString(matchingEventTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchingEventTypes(EventType ... matchingEventTypes) {
            this.matchingEventTypes(Arrays.asList(matchingEventTypes));
            return this;
        }

        public final void setMatchingEventTypes(Collection<String> matchingEventTypes) {
            this.matchingEventTypes = EventTypesCopier.copy(matchingEventTypes);
        }

        public final KinesisFirehoseDestination.Builder getKinesisFirehoseDestination() {
            return this.kinesisFirehoseDestination != null ? this.kinesisFirehoseDestination.toBuilder() : null;
        }

        @Override
        public final Builder kinesisFirehoseDestination(KinesisFirehoseDestination kinesisFirehoseDestination) {
            this.kinesisFirehoseDestination = kinesisFirehoseDestination;
            return this;
        }

        public final void setKinesisFirehoseDestination(KinesisFirehoseDestination.BuilderImpl kinesisFirehoseDestination) {
            this.kinesisFirehoseDestination = kinesisFirehoseDestination != null ? kinesisFirehoseDestination.build() : null;
        }

        public final CloudWatchDestination.Builder getCloudWatchDestination() {
            return this.cloudWatchDestination != null ? this.cloudWatchDestination.toBuilder() : null;
        }

        @Override
        public final Builder cloudWatchDestination(CloudWatchDestination cloudWatchDestination) {
            this.cloudWatchDestination = cloudWatchDestination;
            return this;
        }

        public final void setCloudWatchDestination(CloudWatchDestination.BuilderImpl cloudWatchDestination) {
            this.cloudWatchDestination = cloudWatchDestination != null ? cloudWatchDestination.build() : null;
        }

        public final SNSDestination.Builder getSNSDestination() {
            return this.snsDestination != null ? this.snsDestination.toBuilder() : null;
        }

        @Override
        public final Builder snsDestination(SNSDestination snsDestination) {
            this.snsDestination = snsDestination;
            return this;
        }

        public final void setSNSDestination(SNSDestination.BuilderImpl snsDestination) {
            this.snsDestination = snsDestination != null ? snsDestination.build() : null;
        }

        public EventDestination build() {
            return new EventDestination(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EventDestination> {
        public Builder name(String var1);

        public Builder enabled(Boolean var1);

        public Builder matchingEventTypesWithStrings(Collection<String> var1);

        public Builder matchingEventTypesWithStrings(String ... var1);

        public Builder matchingEventTypes(Collection<EventType> var1);

        public Builder matchingEventTypes(EventType ... var1);

        public Builder kinesisFirehoseDestination(KinesisFirehoseDestination var1);

        default public Builder kinesisFirehoseDestination(Consumer<KinesisFirehoseDestination.Builder> kinesisFirehoseDestination) {
            return this.kinesisFirehoseDestination((KinesisFirehoseDestination)((KinesisFirehoseDestination.Builder)KinesisFirehoseDestination.builder().applyMutation(kinesisFirehoseDestination)).build());
        }

        public Builder cloudWatchDestination(CloudWatchDestination var1);

        default public Builder cloudWatchDestination(Consumer<CloudWatchDestination.Builder> cloudWatchDestination) {
            return this.cloudWatchDestination((CloudWatchDestination)((CloudWatchDestination.Builder)CloudWatchDestination.builder().applyMutation(cloudWatchDestination)).build());
        }

        public Builder snsDestination(SNSDestination var1);

        default public Builder snsDestination(Consumer<SNSDestination.Builder> snsDestination) {
            return this.snsDestination((SNSDestination)((SNSDestination.Builder)SNSDestination.builder().applyMutation(snsDestination)).build());
        }
    }
}

