/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.ses.model.ReceiptRule;
import software.amazon.awssdk.services.ses.model.SesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateReceiptRuleRequest
extends SesRequest
implements ToCopyableBuilder<Builder, CreateReceiptRuleRequest> {
    private final String ruleSetName;
    private final String after;
    private final ReceiptRule rule;

    private CreateReceiptRuleRequest(BuilderImpl builder) {
        super(builder);
        this.ruleSetName = builder.ruleSetName;
        this.after = builder.after;
        this.rule = builder.rule;
    }

    public String ruleSetName() {
        return this.ruleSetName;
    }

    public String after() {
        return this.after;
    }

    public ReceiptRule rule() {
        return this.rule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.after());
        hashCode = 31 * hashCode + Objects.hashCode(this.rule());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReceiptRuleRequest)) {
            return false;
        }
        CreateReceiptRuleRequest other = (CreateReceiptRuleRequest)((Object)obj);
        return Objects.equals(this.ruleSetName(), other.ruleSetName()) && Objects.equals(this.after(), other.after()) && Objects.equals(this.rule(), other.rule());
    }

    public String toString() {
        return ToString.builder((String)"CreateReceiptRuleRequest").add("RuleSetName", (Object)this.ruleSetName()).add("After", (Object)this.after()).add("Rule", (Object)this.rule()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleSetName": {
                return Optional.ofNullable(clazz.cast(this.ruleSetName()));
            }
            case "After": {
                return Optional.ofNullable(clazz.cast(this.after()));
            }
            case "Rule": {
                return Optional.ofNullable(clazz.cast(this.rule()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SesRequest.BuilderImpl
    implements Builder {
        private String ruleSetName;
        private String after;
        private ReceiptRule rule;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReceiptRuleRequest model) {
            super(model);
            this.ruleSetName(model.ruleSetName);
            this.after(model.after);
            this.rule(model.rule);
        }

        public final String getRuleSetName() {
            return this.ruleSetName;
        }

        @Override
        public final Builder ruleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
            return this;
        }

        public final void setRuleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
        }

        public final String getAfter() {
            return this.after;
        }

        @Override
        public final Builder after(String after) {
            this.after = after;
            return this;
        }

        public final void setAfter(String after) {
            this.after = after;
        }

        public final ReceiptRule.Builder getRule() {
            return this.rule != null ? this.rule.toBuilder() : null;
        }

        @Override
        public final Builder rule(ReceiptRule rule) {
            this.rule = rule;
            return this;
        }

        public final void setRule(ReceiptRule.BuilderImpl rule) {
            this.rule = rule != null ? rule.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateReceiptRuleRequest build() {
            return new CreateReceiptRuleRequest(this);
        }
    }

    public static interface Builder
    extends SesRequest.Builder,
    CopyableBuilder<Builder, CreateReceiptRuleRequest> {
        public Builder ruleSetName(String var1);

        public Builder after(String var1);

        public Builder rule(ReceiptRule var1);

        default public Builder rule(Consumer<ReceiptRule.Builder> rule) {
            return this.rule((ReceiptRule)((ReceiptRule.Builder)ReceiptRule.builder().applyMutation(rule)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

