/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ses.model.WorkmailAction;

public class WorkmailActionUnmarshaller
implements Unmarshaller<WorkmailAction, StaxUnmarshallerContext> {
    private static final WorkmailActionUnmarshaller INSTANCE = new WorkmailActionUnmarshaller();

    public WorkmailAction unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        WorkmailAction.Builder workmailAction = WorkmailAction.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("TopicArn", targetDepth)) {
                    workmailAction.topicArn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("OrganizationArn", targetDepth)) continue;
                workmailAction.organizationArn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (WorkmailAction)workmailAction.build();
    }

    public static WorkmailActionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

