/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ses.model.SESResponse;
import software.amazon.awssdk.services.ses.model.VerificationTokenListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class VerifyDomainDkimResponse
extends SESResponse
implements ToCopyableBuilder<Builder, VerifyDomainDkimResponse> {
    private final List<String> dkimTokens;

    private VerifyDomainDkimResponse(BuilderImpl builder) {
        super(builder);
        this.dkimTokens = builder.dkimTokens;
    }

    public List<String> dkimTokens() {
        return this.dkimTokens;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dkimTokens());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifyDomainDkimResponse)) {
            return false;
        }
        VerifyDomainDkimResponse other = (VerifyDomainDkimResponse)((Object)obj);
        return Objects.equals(this.dkimTokens(), other.dkimTokens());
    }

    public String toString() {
        return ToString.builder((String)"VerifyDomainDkimResponse").add("DkimTokens", this.dkimTokens()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DkimTokens": {
                return Optional.of(clazz.cast(this.dkimTokens()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SESResponse.BuilderImpl
    implements Builder {
        private List<String> dkimTokens;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifyDomainDkimResponse model) {
            super(model);
            this.dkimTokens(model.dkimTokens);
        }

        public final Collection<String> getDkimTokens() {
            return this.dkimTokens;
        }

        @Override
        public final Builder dkimTokens(Collection<String> dkimTokens) {
            this.dkimTokens = VerificationTokenListCopier.copy(dkimTokens);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dkimTokens(String ... dkimTokens) {
            this.dkimTokens(Arrays.asList(dkimTokens));
            return this;
        }

        public final void setDkimTokens(Collection<String> dkimTokens) {
            this.dkimTokens = VerificationTokenListCopier.copy(dkimTokens);
        }

        @Override
        public VerifyDomainDkimResponse build() {
            return new VerifyDomainDkimResponse(this);
        }
    }

    public static interface Builder
    extends SESResponse.Builder,
    CopyableBuilder<Builder, VerifyDomainDkimResponse> {
        public Builder dkimTokens(Collection<String> var1);

        public Builder dkimTokens(String ... var1);
    }
}

