/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ses.model.NotificationType;
import software.amazon.awssdk.services.ses.model.SESRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SetIdentityNotificationTopicRequest
extends SESRequest
implements ToCopyableBuilder<Builder, SetIdentityNotificationTopicRequest> {
    private final String identity;
    private final String notificationType;
    private final String snsTopic;

    private SetIdentityNotificationTopicRequest(BuilderImpl builder) {
        super(builder);
        this.identity = builder.identity;
        this.notificationType = builder.notificationType;
        this.snsTopic = builder.snsTopic;
    }

    public String identity() {
        return this.identity;
    }

    public NotificationType notificationType() {
        return NotificationType.fromValue(this.notificationType);
    }

    public String notificationTypeAsString() {
        return this.notificationType;
    }

    public String snsTopic() {
        return this.snsTopic;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identity());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsTopic());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetIdentityNotificationTopicRequest)) {
            return false;
        }
        SetIdentityNotificationTopicRequest other = (SetIdentityNotificationTopicRequest)((Object)obj);
        return Objects.equals(this.identity(), other.identity()) && Objects.equals(this.notificationTypeAsString(), other.notificationTypeAsString()) && Objects.equals(this.snsTopic(), other.snsTopic());
    }

    public String toString() {
        return ToString.builder((String)"SetIdentityNotificationTopicRequest").add("Identity", (Object)this.identity()).add("NotificationType", (Object)this.notificationTypeAsString()).add("SnsTopic", (Object)this.snsTopic()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Identity": {
                return Optional.of(clazz.cast(this.identity()));
            }
            case "NotificationType": {
                return Optional.of(clazz.cast(this.notificationTypeAsString()));
            }
            case "SnsTopic": {
                return Optional.of(clazz.cast(this.snsTopic()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SESRequest.BuilderImpl
    implements Builder {
        private String identity;
        private String notificationType;
        private String snsTopic;

        private BuilderImpl() {
        }

        private BuilderImpl(SetIdentityNotificationTopicRequest model) {
            super(model);
            this.identity(model.identity);
            this.notificationType(model.notificationType);
            this.snsTopic(model.snsTopic);
        }

        public final String getIdentity() {
            return this.identity;
        }

        @Override
        public final Builder identity(String identity) {
            this.identity = identity;
            return this;
        }

        public final void setIdentity(String identity) {
            this.identity = identity;
        }

        public final String getNotificationType() {
            return this.notificationType;
        }

        @Override
        public final Builder notificationType(String notificationType) {
            this.notificationType = notificationType;
            return this;
        }

        @Override
        public final Builder notificationType(NotificationType notificationType) {
            this.notificationType(notificationType.toString());
            return this;
        }

        public final void setNotificationType(String notificationType) {
            this.notificationType = notificationType;
        }

        public final String getSnsTopic() {
            return this.snsTopic;
        }

        @Override
        public final Builder snsTopic(String snsTopic) {
            this.snsTopic = snsTopic;
            return this;
        }

        public final void setSnsTopic(String snsTopic) {
            this.snsTopic = snsTopic;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public SetIdentityNotificationTopicRequest build() {
            return new SetIdentityNotificationTopicRequest(this);
        }
    }

    public static interface Builder
    extends SESRequest.Builder,
    CopyableBuilder<Builder, SetIdentityNotificationTopicRequest> {
        public Builder identity(String var1);

        public Builder notificationType(String var1);

        public Builder notificationType(NotificationType var1);

        public Builder snsTopic(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

