/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReputationOptions
implements ToCopyableBuilder<Builder, ReputationOptions> {
    private final Boolean sendingEnabled;
    private final Boolean reputationMetricsEnabled;
    private final Instant lastFreshStart;

    private ReputationOptions(BuilderImpl builder) {
        this.sendingEnabled = builder.sendingEnabled;
        this.reputationMetricsEnabled = builder.reputationMetricsEnabled;
        this.lastFreshStart = builder.lastFreshStart;
    }

    public Boolean sendingEnabled() {
        return this.sendingEnabled;
    }

    public Boolean reputationMetricsEnabled() {
        return this.reputationMetricsEnabled;
    }

    public Instant lastFreshStart() {
        return this.lastFreshStart;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sendingEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.reputationMetricsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastFreshStart());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReputationOptions)) {
            return false;
        }
        ReputationOptions other = (ReputationOptions)obj;
        return Objects.equals(this.sendingEnabled(), other.sendingEnabled()) && Objects.equals(this.reputationMetricsEnabled(), other.reputationMetricsEnabled()) && Objects.equals(this.lastFreshStart(), other.lastFreshStart());
    }

    public String toString() {
        return ToString.builder((String)"ReputationOptions").add("SendingEnabled", (Object)this.sendingEnabled()).add("ReputationMetricsEnabled", (Object)this.reputationMetricsEnabled()).add("LastFreshStart", (Object)this.lastFreshStart()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SendingEnabled": {
                return Optional.of(clazz.cast(this.sendingEnabled()));
            }
            case "ReputationMetricsEnabled": {
                return Optional.of(clazz.cast(this.reputationMetricsEnabled()));
            }
            case "LastFreshStart": {
                return Optional.of(clazz.cast(this.lastFreshStart()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean sendingEnabled;
        private Boolean reputationMetricsEnabled;
        private Instant lastFreshStart;

        private BuilderImpl() {
        }

        private BuilderImpl(ReputationOptions model) {
            this.sendingEnabled(model.sendingEnabled);
            this.reputationMetricsEnabled(model.reputationMetricsEnabled);
            this.lastFreshStart(model.lastFreshStart);
        }

        public final Boolean getSendingEnabled() {
            return this.sendingEnabled;
        }

        @Override
        public final Builder sendingEnabled(Boolean sendingEnabled) {
            this.sendingEnabled = sendingEnabled;
            return this;
        }

        public final void setSendingEnabled(Boolean sendingEnabled) {
            this.sendingEnabled = sendingEnabled;
        }

        public final Boolean getReputationMetricsEnabled() {
            return this.reputationMetricsEnabled;
        }

        @Override
        public final Builder reputationMetricsEnabled(Boolean reputationMetricsEnabled) {
            this.reputationMetricsEnabled = reputationMetricsEnabled;
            return this;
        }

        public final void setReputationMetricsEnabled(Boolean reputationMetricsEnabled) {
            this.reputationMetricsEnabled = reputationMetricsEnabled;
        }

        public final Instant getLastFreshStart() {
            return this.lastFreshStart;
        }

        @Override
        public final Builder lastFreshStart(Instant lastFreshStart) {
            this.lastFreshStart = lastFreshStart;
            return this;
        }

        public final void setLastFreshStart(Instant lastFreshStart) {
            this.lastFreshStart = lastFreshStart;
        }

        public ReputationOptions build() {
            return new ReputationOptions(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReputationOptions> {
        public Builder sendingEnabled(Boolean var1);

        public Builder reputationMetricsEnabled(Boolean var1);

        public Builder lastFreshStart(Instant var1);
    }
}

