/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ses.model.CloudWatchDestination;
import software.amazon.awssdk.services.ses.model.CloudWatchDimensionConfiguration;
import software.amazon.awssdk.services.ses.model.EventDestination;
import software.amazon.awssdk.services.ses.model.KinesisFirehoseDestination;
import software.amazon.awssdk.services.ses.model.UpdateConfigurationSetEventDestinationRequest;
import software.amazon.awssdk.util.StringUtils;

public class UpdateConfigurationSetEventDestinationRequestMarshaller
implements Marshaller<Request<UpdateConfigurationSetEventDestinationRequest>, UpdateConfigurationSetEventDestinationRequest> {
    public Request<UpdateConfigurationSetEventDestinationRequest> marshall(UpdateConfigurationSetEventDestinationRequest updateConfigurationSetEventDestinationRequest) {
        EventDestination eventDestination;
        if (updateConfigurationSetEventDestinationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateConfigurationSetEventDestinationRequest, "SESClient");
        request.addParameter("Action", "UpdateConfigurationSetEventDestination");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateConfigurationSetEventDestinationRequest.configurationSetName() != null) {
            request.addParameter("ConfigurationSetName", StringUtils.fromString((String)updateConfigurationSetEventDestinationRequest.configurationSetName()));
        }
        if ((eventDestination = updateConfigurationSetEventDestinationRequest.eventDestination()) != null) {
            SdkInternalList dimensionConfigurationsList;
            CloudWatchDestination cloudWatchDestination;
            KinesisFirehoseDestination kinesisFirehoseDestination;
            SdkInternalList matchingEventTypesList;
            if (eventDestination.name() != null) {
                request.addParameter("EventDestination.Name", StringUtils.fromString((String)eventDestination.name()));
            }
            if (eventDestination.enabled() != null) {
                request.addParameter("EventDestination.Enabled", StringUtils.fromBoolean((Boolean)eventDestination.enabled()));
            }
            if (!(matchingEventTypesList = (SdkInternalList)eventDestination.matchingEventTypes()).isEmpty() || !matchingEventTypesList.isAutoConstruct()) {
                int matchingEventTypesListIndex = 1;
                for (String matchingEventTypesListValue : matchingEventTypesList) {
                    if (matchingEventTypesListValue != null) {
                        request.addParameter("EventDestination.MatchingEventTypes.member." + matchingEventTypesListIndex, StringUtils.fromString((String)matchingEventTypesListValue));
                    }
                    ++matchingEventTypesListIndex;
                }
            }
            if ((kinesisFirehoseDestination = eventDestination.kinesisFirehoseDestination()) != null) {
                if (kinesisFirehoseDestination.iamRoleARN() != null) {
                    request.addParameter("EventDestination.KinesisFirehoseDestination.IAMRoleARN", StringUtils.fromString((String)kinesisFirehoseDestination.iamRoleARN()));
                }
                if (kinesisFirehoseDestination.deliveryStreamARN() != null) {
                    request.addParameter("EventDestination.KinesisFirehoseDestination.DeliveryStreamARN", StringUtils.fromString((String)kinesisFirehoseDestination.deliveryStreamARN()));
                }
            }
            if (!((cloudWatchDestination = eventDestination.cloudWatchDestination()) == null || (dimensionConfigurationsList = (SdkInternalList)cloudWatchDestination.dimensionConfigurations()).isEmpty() && dimensionConfigurationsList.isAutoConstruct())) {
                int dimensionConfigurationsListIndex = 1;
                for (CloudWatchDimensionConfiguration dimensionConfigurationsListValue : dimensionConfigurationsList) {
                    if (dimensionConfigurationsListValue.dimensionName() != null) {
                        request.addParameter("EventDestination.CloudWatchDestination.DimensionConfigurations.member." + dimensionConfigurationsListIndex + ".DimensionName", StringUtils.fromString((String)dimensionConfigurationsListValue.dimensionName()));
                    }
                    if (dimensionConfigurationsListValue.dimensionValueSource() != null) {
                        request.addParameter("EventDestination.CloudWatchDestination.DimensionConfigurations.member." + dimensionConfigurationsListIndex + ".DimensionValueSource", StringUtils.fromString((String)dimensionConfigurationsListValue.dimensionValueSource()));
                    }
                    if (dimensionConfigurationsListValue.defaultDimensionValue() != null) {
                        request.addParameter("EventDestination.CloudWatchDestination.DimensionConfigurations.member." + dimensionConfigurationsListIndex + ".DefaultDimensionValue", StringUtils.fromString((String)dimensionConfigurationsListValue.defaultDimensionValue()));
                    }
                    ++dimensionConfigurationsListIndex;
                }
            }
        }
        return request;
    }
}

