/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ses.model.EventDestination;
import software.amazon.awssdk.services.ses.transform.CloudWatchDestinationUnmarshaller;
import software.amazon.awssdk.services.ses.transform.KinesisFirehoseDestinationUnmarshaller;

public class EventDestinationUnmarshaller
implements Unmarshaller<EventDestination, StaxUnmarshallerContext> {
    private static EventDestinationUnmarshaller INSTANCE;

    public EventDestination unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        EventDestination.Builder eventDestination = EventDestination.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Name", targetDepth)) {
                    eventDestination.name(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Enabled", targetDepth)) {
                    eventDestination.enabled(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MatchingEventTypes", targetDepth)) {
                    eventDestination.matchingEventTypes(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("MatchingEventTypes/member", targetDepth)) {
                    eventDestination.matchingEventTypes(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("KinesisFirehoseDestination", targetDepth)) {
                    eventDestination.kinesisFirehoseDestination(KinesisFirehoseDestinationUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("CloudWatchDestination", targetDepth)) continue;
                eventDestination.cloudWatchDestination(CloudWatchDestinationUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (EventDestination)eventDestination.build();
    }

    public static EventDestinationUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new EventDestinationUnmarshaller();
        }
        return INSTANCE;
    }
}

