/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ses.model.Destination;

public class DestinationUnmarshaller
implements Unmarshaller<Destination, StaxUnmarshallerContext> {
    private static DestinationUnmarshaller INSTANCE;

    public Destination unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        Destination.Builder destination = Destination.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ToAddresses", targetDepth)) {
                    destination.toAddresses(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("ToAddresses/member", targetDepth)) {
                    destination.toAddresses(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CcAddresses", targetDepth)) {
                    destination.ccAddresses(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("CcAddresses/member", targetDepth)) {
                    destination.ccAddresses(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("BccAddresses", targetDepth)) {
                    destination.bccAddresses(new ArrayList<String>());
                    continue;
                }
                if (!context.testExpression("BccAddresses/member", targetDepth)) continue;
                destination.bccAddresses(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (Destination)destination.build();
    }

    public static DestinationUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DestinationUnmarshaller();
        }
        return INSTANCE;
    }
}

