/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ses.model.CreateReceiptFilterRequest;
import software.amazon.awssdk.services.ses.model.ReceiptFilter;
import software.amazon.awssdk.services.ses.model.ReceiptIpFilter;
import software.amazon.awssdk.util.StringUtils;

public class CreateReceiptFilterRequestMarshaller
implements Marshaller<Request<CreateReceiptFilterRequest>, CreateReceiptFilterRequest> {
    public Request<CreateReceiptFilterRequest> marshall(CreateReceiptFilterRequest createReceiptFilterRequest) {
        if (createReceiptFilterRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createReceiptFilterRequest, "SESClient");
        request.addParameter("Action", "CreateReceiptFilter");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        ReceiptFilter filter = createReceiptFilterRequest.filter();
        if (filter != null) {
            ReceiptIpFilter ipFilter;
            if (filter.name() != null) {
                request.addParameter("Filter.Name", StringUtils.fromString((String)filter.name()));
            }
            if ((ipFilter = filter.ipFilter()) != null) {
                if (ipFilter.policy() != null) {
                    request.addParameter("Filter.IpFilter.Policy", StringUtils.fromString((String)ipFilter.policy()));
                }
                if (ipFilter.cidr() != null) {
                    request.addParameter("Filter.IpFilter.Cidr", StringUtils.fromString((String)ipFilter.cidr()));
                }
            }
        }
        return request;
    }
}

