/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalMap;
import software.amazon.awssdk.services.ses.model.IdentityNotificationAttributes;
import software.amazon.awssdk.services.ses.model.NotificationAttributesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetIdentityNotificationAttributesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetIdentityNotificationAttributesResponse> {
    private final Map<String, IdentityNotificationAttributes> notificationAttributes;

    private GetIdentityNotificationAttributesResponse(BuilderImpl builder) {
        this.notificationAttributes = builder.notificationAttributes;
    }

    public Map<String, IdentityNotificationAttributes> notificationAttributes() {
        return this.notificationAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.notificationAttributes() == null ? 0 : this.notificationAttributes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdentityNotificationAttributesResponse)) {
            return false;
        }
        GetIdentityNotificationAttributesResponse other = (GetIdentityNotificationAttributesResponse)((Object)obj);
        if (other.notificationAttributes() == null ^ this.notificationAttributes() == null) {
            return false;
        }
        return other.notificationAttributes() == null || other.notificationAttributes().equals(this.notificationAttributes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.notificationAttributes() != null) {
            sb.append("NotificationAttributes: ").append(this.notificationAttributes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Map<String, IdentityNotificationAttributes> notificationAttributes = new SdkInternalMap();

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdentityNotificationAttributesResponse model) {
            this.setNotificationAttributes(model.notificationAttributes);
        }

        public final Map<String, IdentityNotificationAttributes> getNotificationAttributes() {
            return this.notificationAttributes;
        }

        @Override
        public final Builder notificationAttributes(Map<String, IdentityNotificationAttributes> notificationAttributes) {
            this.notificationAttributes = NotificationAttributesCopier.copy(notificationAttributes);
            return this;
        }

        public final void setNotificationAttributes(Map<String, IdentityNotificationAttributes> notificationAttributes) {
            this.notificationAttributes = NotificationAttributesCopier.copy(notificationAttributes);
        }

        public GetIdentityNotificationAttributesResponse build() {
            return new GetIdentityNotificationAttributesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetIdentityNotificationAttributesResponse> {
        public Builder notificationAttributes(Map<String, IdentityNotificationAttributes> var1);
    }
}

