/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicequotas.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicequotas.ServiceQuotasAsyncClient;
import software.amazon.awssdk.services.servicequotas.model.ListAwsDefaultServiceQuotasRequest;
import software.amazon.awssdk.services.servicequotas.model.ListAwsDefaultServiceQuotasResponse;
import software.amazon.awssdk.services.servicequotas.model.ServiceQuota;

public class ListAWSDefaultServiceQuotasPublisher
implements SdkPublisher<ListAwsDefaultServiceQuotasResponse> {
    private final ServiceQuotasAsyncClient client;
    private final ListAwsDefaultServiceQuotasRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAWSDefaultServiceQuotasPublisher(ServiceQuotasAsyncClient client, ListAwsDefaultServiceQuotasRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAWSDefaultServiceQuotasPublisher(ServiceQuotasAsyncClient client, ListAwsDefaultServiceQuotasRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAwsDefaultServiceQuotasResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAwsDefaultServiceQuotasResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ServiceQuota> quotas() {
        Function<ListAwsDefaultServiceQuotasResponse, Iterator> getIterator = response -> {
            if (response != null && response.quotas() != null) {
                return response.quotas().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAwsDefaultServiceQuotasResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAwsDefaultServiceQuotasResponseFetcher
    implements AsyncPageFetcher<ListAwsDefaultServiceQuotasResponse> {
        private ListAwsDefaultServiceQuotasResponseFetcher() {
        }

        public boolean hasNextPage(ListAwsDefaultServiceQuotasResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAwsDefaultServiceQuotasResponse> nextPage(ListAwsDefaultServiceQuotasResponse previousPage) {
            if (previousPage == null) {
                return ListAWSDefaultServiceQuotasPublisher.this.client.listAWSDefaultServiceQuotas(ListAWSDefaultServiceQuotasPublisher.this.firstRequest);
            }
            return ListAWSDefaultServiceQuotasPublisher.this.client.listAWSDefaultServiceQuotas((ListAwsDefaultServiceQuotasRequest)((Object)ListAWSDefaultServiceQuotasPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

