/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicequotas.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicequotas.ServiceQuotasAsyncClient;
import software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryRequest;
import software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryResponse;
import software.amazon.awssdk.services.servicequotas.model.RequestedServiceQuotaChange;

public class ListRequestedServiceQuotaChangeHistoryPublisher
implements SdkPublisher<ListRequestedServiceQuotaChangeHistoryResponse> {
    private final ServiceQuotasAsyncClient client;
    private final ListRequestedServiceQuotaChangeHistoryRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRequestedServiceQuotaChangeHistoryPublisher(ServiceQuotasAsyncClient client, ListRequestedServiceQuotaChangeHistoryRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRequestedServiceQuotaChangeHistoryPublisher(ServiceQuotasAsyncClient client, ListRequestedServiceQuotaChangeHistoryRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRequestedServiceQuotaChangeHistoryResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRequestedServiceQuotaChangeHistoryResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RequestedServiceQuotaChange> requestedQuotas() {
        Function<ListRequestedServiceQuotaChangeHistoryResponse, Iterator> getIterator = response -> {
            if (response != null && response.requestedQuotas() != null) {
                return response.requestedQuotas().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRequestedServiceQuotaChangeHistoryResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRequestedServiceQuotaChangeHistoryResponseFetcher
    implements AsyncPageFetcher<ListRequestedServiceQuotaChangeHistoryResponse> {
        private ListRequestedServiceQuotaChangeHistoryResponseFetcher() {
        }

        public boolean hasNextPage(ListRequestedServiceQuotaChangeHistoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRequestedServiceQuotaChangeHistoryResponse> nextPage(ListRequestedServiceQuotaChangeHistoryResponse previousPage) {
            if (previousPage == null) {
                return ListRequestedServiceQuotaChangeHistoryPublisher.this.client.listRequestedServiceQuotaChangeHistory(ListRequestedServiceQuotaChangeHistoryPublisher.this.firstRequest);
            }
            return ListRequestedServiceQuotaChangeHistoryPublisher.this.client.listRequestedServiceQuotaChangeHistory((ListRequestedServiceQuotaChangeHistoryRequest)((Object)ListRequestedServiceQuotaChangeHistoryPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

