/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicequotas.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AppliedLevelEnum {
    ACCOUNT("ACCOUNT"),
    RESOURCE("RESOURCE"),
    ALL("ALL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AppliedLevelEnum> VALUE_MAP;
    private final String value;

    private AppliedLevelEnum(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AppliedLevelEnum fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AppliedLevelEnum> knownValues() {
        EnumSet<AppliedLevelEnum> knownValues = EnumSet.allOf(AppliedLevelEnum.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AppliedLevelEnum.class, AppliedLevelEnum::toString);
    }
}

