/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicequotas.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicequotas.model.RequestedServiceQuotaChange;
import software.amazon.awssdk.services.servicequotas.model.RequestedServiceQuotaChangeHistoryListDefinitionCopier;
import software.amazon.awssdk.services.servicequotas.model.ServiceQuotasResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRequestedServiceQuotaChangeHistoryResponse
extends ServiceQuotasResponse
implements ToCopyableBuilder<Builder, ListRequestedServiceQuotaChangeHistoryResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRequestedServiceQuotaChangeHistoryResponse.getter(ListRequestedServiceQuotaChangeHistoryResponse::nextToken)).setter(ListRequestedServiceQuotaChangeHistoryResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<RequestedServiceQuotaChange>> REQUESTED_QUOTAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RequestedQuotas").getter(ListRequestedServiceQuotaChangeHistoryResponse.getter(ListRequestedServiceQuotaChangeHistoryResponse::requestedQuotas)).setter(ListRequestedServiceQuotaChangeHistoryResponse.setter(Builder::requestedQuotas)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestedQuotas").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RequestedServiceQuotaChange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, REQUESTED_QUOTAS_FIELD));
    private final String nextToken;
    private final List<RequestedServiceQuotaChange> requestedQuotas;

    private ListRequestedServiceQuotaChangeHistoryResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.requestedQuotas = builder.requestedQuotas;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public boolean hasRequestedQuotas() {
        return this.requestedQuotas != null && !(this.requestedQuotas instanceof SdkAutoConstructList);
    }

    public List<RequestedServiceQuotaChange> requestedQuotas() {
        return this.requestedQuotas;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequestedQuotas() ? this.requestedQuotas() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRequestedServiceQuotaChangeHistoryResponse)) {
            return false;
        }
        ListRequestedServiceQuotaChangeHistoryResponse other = (ListRequestedServiceQuotaChangeHistoryResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasRequestedQuotas() == other.hasRequestedQuotas() && Objects.equals(this.requestedQuotas(), other.requestedQuotas());
    }

    public String toString() {
        return ToString.builder((String)"ListRequestedServiceQuotaChangeHistoryResponse").add("NextToken", (Object)this.nextToken()).add("RequestedQuotas", this.hasRequestedQuotas() ? this.requestedQuotas() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "RequestedQuotas": {
                return Optional.ofNullable(clazz.cast(this.requestedQuotas()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRequestedServiceQuotaChangeHistoryResponse, T> g) {
        return obj -> g.apply((ListRequestedServiceQuotaChangeHistoryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceQuotasResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<RequestedServiceQuotaChange> requestedQuotas = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRequestedServiceQuotaChangeHistoryResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.requestedQuotas(model.requestedQuotas);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<RequestedServiceQuotaChange.Builder> getRequestedQuotas() {
            if (this.requestedQuotas instanceof SdkAutoConstructList) {
                return null;
            }
            return this.requestedQuotas != null ? (Collection)this.requestedQuotas.stream().map(RequestedServiceQuotaChange::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder requestedQuotas(Collection<RequestedServiceQuotaChange> requestedQuotas) {
            this.requestedQuotas = RequestedServiceQuotaChangeHistoryListDefinitionCopier.copy(requestedQuotas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requestedQuotas(RequestedServiceQuotaChange ... requestedQuotas) {
            this.requestedQuotas(Arrays.asList(requestedQuotas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requestedQuotas(Consumer<RequestedServiceQuotaChange.Builder> ... requestedQuotas) {
            this.requestedQuotas(Stream.of(requestedQuotas).map(c -> (RequestedServiceQuotaChange)((RequestedServiceQuotaChange.Builder)RequestedServiceQuotaChange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRequestedQuotas(Collection<RequestedServiceQuotaChange.BuilderImpl> requestedQuotas) {
            this.requestedQuotas = RequestedServiceQuotaChangeHistoryListDefinitionCopier.copyFromBuilder(requestedQuotas);
        }

        @Override
        public ListRequestedServiceQuotaChangeHistoryResponse build() {
            return new ListRequestedServiceQuotaChangeHistoryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceQuotasResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRequestedServiceQuotaChangeHistoryResponse> {
        public Builder nextToken(String var1);

        public Builder requestedQuotas(Collection<RequestedServiceQuotaChange> var1);

        public Builder requestedQuotas(RequestedServiceQuotaChange ... var1);

        public Builder requestedQuotas(Consumer<RequestedServiceQuotaChange.Builder> ... var1);
    }
}

