/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicequotas.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicequotas.model.ErrorReason;
import software.amazon.awssdk.services.servicequotas.model.MetricInfo;
import software.amazon.awssdk.services.servicequotas.model.QuotaPeriod;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceQuota
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceQuota> {
    private static final SdkField<String> SERVICE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceCode").getter(ServiceQuota.getter(ServiceQuota::serviceCode)).setter(ServiceQuota.setter(Builder::serviceCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceCode").build()}).build();
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceName").getter(ServiceQuota.getter(ServiceQuota::serviceName)).setter(ServiceQuota.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").build()}).build();
    private static final SdkField<String> QUOTA_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuotaArn").getter(ServiceQuota.getter(ServiceQuota::quotaArn)).setter(ServiceQuota.setter(Builder::quotaArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuotaArn").build()}).build();
    private static final SdkField<String> QUOTA_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuotaCode").getter(ServiceQuota.getter(ServiceQuota::quotaCode)).setter(ServiceQuota.setter(Builder::quotaCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuotaCode").build()}).build();
    private static final SdkField<String> QUOTA_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuotaName").getter(ServiceQuota.getter(ServiceQuota::quotaName)).setter(ServiceQuota.setter(Builder::quotaName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuotaName").build()}).build();
    private static final SdkField<Double> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Value").getter(ServiceQuota.getter(ServiceQuota::value)).setter(ServiceQuota.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<String> UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Unit").getter(ServiceQuota.getter(ServiceQuota::unit)).setter(ServiceQuota.setter(Builder::unit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()}).build();
    private static final SdkField<Boolean> ADJUSTABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Adjustable").getter(ServiceQuota.getter(ServiceQuota::adjustable)).setter(ServiceQuota.setter(Builder::adjustable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Adjustable").build()}).build();
    private static final SdkField<Boolean> GLOBAL_QUOTA_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("GlobalQuota").getter(ServiceQuota.getter(ServiceQuota::globalQuota)).setter(ServiceQuota.setter(Builder::globalQuota)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalQuota").build()}).build();
    private static final SdkField<MetricInfo> USAGE_METRIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UsageMetric").getter(ServiceQuota.getter(ServiceQuota::usageMetric)).setter(ServiceQuota.setter(Builder::usageMetric)).constructor(MetricInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageMetric").build()}).build();
    private static final SdkField<QuotaPeriod> PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Period").getter(ServiceQuota.getter(ServiceQuota::period)).setter(ServiceQuota.setter(Builder::period)).constructor(QuotaPeriod::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Period").build()}).build();
    private static final SdkField<ErrorReason> ERROR_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ErrorReason").getter(ServiceQuota.getter(ServiceQuota::errorReason)).setter(ServiceQuota.setter(Builder::errorReason)).constructor(ErrorReason::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_CODE_FIELD, SERVICE_NAME_FIELD, QUOTA_ARN_FIELD, QUOTA_CODE_FIELD, QUOTA_NAME_FIELD, VALUE_FIELD, UNIT_FIELD, ADJUSTABLE_FIELD, GLOBAL_QUOTA_FIELD, USAGE_METRIC_FIELD, PERIOD_FIELD, ERROR_REASON_FIELD));
    private static final long serialVersionUID = 1L;
    private final String serviceCode;
    private final String serviceName;
    private final String quotaArn;
    private final String quotaCode;
    private final String quotaName;
    private final Double value;
    private final String unit;
    private final Boolean adjustable;
    private final Boolean globalQuota;
    private final MetricInfo usageMetric;
    private final QuotaPeriod period;
    private final ErrorReason errorReason;

    private ServiceQuota(BuilderImpl builder) {
        this.serviceCode = builder.serviceCode;
        this.serviceName = builder.serviceName;
        this.quotaArn = builder.quotaArn;
        this.quotaCode = builder.quotaCode;
        this.quotaName = builder.quotaName;
        this.value = builder.value;
        this.unit = builder.unit;
        this.adjustable = builder.adjustable;
        this.globalQuota = builder.globalQuota;
        this.usageMetric = builder.usageMetric;
        this.period = builder.period;
        this.errorReason = builder.errorReason;
    }

    public String serviceCode() {
        return this.serviceCode;
    }

    public String serviceName() {
        return this.serviceName;
    }

    public String quotaArn() {
        return this.quotaArn;
    }

    public String quotaCode() {
        return this.quotaCode;
    }

    public String quotaName() {
        return this.quotaName;
    }

    public Double value() {
        return this.value;
    }

    public String unit() {
        return this.unit;
    }

    public Boolean adjustable() {
        return this.adjustable;
    }

    public Boolean globalQuota() {
        return this.globalQuota;
    }

    public MetricInfo usageMetric() {
        return this.usageMetric;
    }

    public QuotaPeriod period() {
        return this.period;
    }

    public ErrorReason errorReason() {
        return this.errorReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.quotaArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.quotaCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.quotaName());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.unit());
        hashCode = 31 * hashCode + Objects.hashCode(this.adjustable());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalQuota());
        hashCode = 31 * hashCode + Objects.hashCode(this.usageMetric());
        hashCode = 31 * hashCode + Objects.hashCode(this.period());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorReason());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceQuota)) {
            return false;
        }
        ServiceQuota other = (ServiceQuota)obj;
        return Objects.equals(this.serviceCode(), other.serviceCode()) && Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.quotaArn(), other.quotaArn()) && Objects.equals(this.quotaCode(), other.quotaCode()) && Objects.equals(this.quotaName(), other.quotaName()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.unit(), other.unit()) && Objects.equals(this.adjustable(), other.adjustable()) && Objects.equals(this.globalQuota(), other.globalQuota()) && Objects.equals(this.usageMetric(), other.usageMetric()) && Objects.equals(this.period(), other.period()) && Objects.equals(this.errorReason(), other.errorReason());
    }

    public String toString() {
        return ToString.builder((String)"ServiceQuota").add("ServiceCode", (Object)this.serviceCode()).add("ServiceName", (Object)this.serviceName()).add("QuotaArn", (Object)this.quotaArn()).add("QuotaCode", (Object)this.quotaCode()).add("QuotaName", (Object)this.quotaName()).add("Value", (Object)this.value()).add("Unit", (Object)this.unit()).add("Adjustable", (Object)this.adjustable()).add("GlobalQuota", (Object)this.globalQuota()).add("UsageMetric", (Object)this.usageMetric()).add("Period", (Object)this.period()).add("ErrorReason", (Object)this.errorReason()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceCode": {
                return Optional.ofNullable(clazz.cast(this.serviceCode()));
            }
            case "ServiceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
            case "QuotaArn": {
                return Optional.ofNullable(clazz.cast(this.quotaArn()));
            }
            case "QuotaCode": {
                return Optional.ofNullable(clazz.cast(this.quotaCode()));
            }
            case "QuotaName": {
                return Optional.ofNullable(clazz.cast(this.quotaName()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "Unit": {
                return Optional.ofNullable(clazz.cast(this.unit()));
            }
            case "Adjustable": {
                return Optional.ofNullable(clazz.cast(this.adjustable()));
            }
            case "GlobalQuota": {
                return Optional.ofNullable(clazz.cast(this.globalQuota()));
            }
            case "UsageMetric": {
                return Optional.ofNullable(clazz.cast(this.usageMetric()));
            }
            case "Period": {
                return Optional.ofNullable(clazz.cast(this.period()));
            }
            case "ErrorReason": {
                return Optional.ofNullable(clazz.cast(this.errorReason()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceQuota, T> g) {
        return obj -> g.apply((ServiceQuota)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceCode;
        private String serviceName;
        private String quotaArn;
        private String quotaCode;
        private String quotaName;
        private Double value;
        private String unit;
        private Boolean adjustable;
        private Boolean globalQuota;
        private MetricInfo usageMetric;
        private QuotaPeriod period;
        private ErrorReason errorReason;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceQuota model) {
            this.serviceCode(model.serviceCode);
            this.serviceName(model.serviceName);
            this.quotaArn(model.quotaArn);
            this.quotaCode(model.quotaCode);
            this.quotaName(model.quotaName);
            this.value(model.value);
            this.unit(model.unit);
            this.adjustable(model.adjustable);
            this.globalQuota(model.globalQuota);
            this.usageMetric(model.usageMetric);
            this.period(model.period);
            this.errorReason(model.errorReason);
        }

        public final String getServiceCode() {
            return this.serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public final String getQuotaArn() {
            return this.quotaArn;
        }

        @Override
        public final Builder quotaArn(String quotaArn) {
            this.quotaArn = quotaArn;
            return this;
        }

        public final void setQuotaArn(String quotaArn) {
            this.quotaArn = quotaArn;
        }

        public final String getQuotaCode() {
            return this.quotaCode;
        }

        @Override
        public final Builder quotaCode(String quotaCode) {
            this.quotaCode = quotaCode;
            return this;
        }

        public final void setQuotaCode(String quotaCode) {
            this.quotaCode = quotaCode;
        }

        public final String getQuotaName() {
            return this.quotaName;
        }

        @Override
        public final Builder quotaName(String quotaName) {
            this.quotaName = quotaName;
            return this;
        }

        public final void setQuotaName(String quotaName) {
            this.quotaName = quotaName;
        }

        public final Double getValue() {
            return this.value;
        }

        @Override
        public final Builder value(Double value) {
            this.value = value;
            return this;
        }

        public final void setValue(Double value) {
            this.value = value;
        }

        public final String getUnit() {
            return this.unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        public final Boolean getAdjustable() {
            return this.adjustable;
        }

        @Override
        public final Builder adjustable(Boolean adjustable) {
            this.adjustable = adjustable;
            return this;
        }

        public final void setAdjustable(Boolean adjustable) {
            this.adjustable = adjustable;
        }

        public final Boolean getGlobalQuota() {
            return this.globalQuota;
        }

        @Override
        public final Builder globalQuota(Boolean globalQuota) {
            this.globalQuota = globalQuota;
            return this;
        }

        public final void setGlobalQuota(Boolean globalQuota) {
            this.globalQuota = globalQuota;
        }

        public final MetricInfo.Builder getUsageMetric() {
            return this.usageMetric != null ? this.usageMetric.toBuilder() : null;
        }

        @Override
        public final Builder usageMetric(MetricInfo usageMetric) {
            this.usageMetric = usageMetric;
            return this;
        }

        public final void setUsageMetric(MetricInfo.BuilderImpl usageMetric) {
            this.usageMetric = usageMetric != null ? usageMetric.build() : null;
        }

        public final QuotaPeriod.Builder getPeriod() {
            return this.period != null ? this.period.toBuilder() : null;
        }

        @Override
        public final Builder period(QuotaPeriod period) {
            this.period = period;
            return this;
        }

        public final void setPeriod(QuotaPeriod.BuilderImpl period) {
            this.period = period != null ? period.build() : null;
        }

        public final ErrorReason.Builder getErrorReason() {
            return this.errorReason != null ? this.errorReason.toBuilder() : null;
        }

        @Override
        public final Builder errorReason(ErrorReason errorReason) {
            this.errorReason = errorReason;
            return this;
        }

        public final void setErrorReason(ErrorReason.BuilderImpl errorReason) {
            this.errorReason = errorReason != null ? errorReason.build() : null;
        }

        public ServiceQuota build() {
            return new ServiceQuota(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceQuota> {
        public Builder serviceCode(String var1);

        public Builder serviceName(String var1);

        public Builder quotaArn(String var1);

        public Builder quotaCode(String var1);

        public Builder quotaName(String var1);

        public Builder value(Double var1);

        public Builder unit(String var1);

        public Builder adjustable(Boolean var1);

        public Builder globalQuota(Boolean var1);

        public Builder usageMetric(MetricInfo var1);

        default public Builder usageMetric(Consumer<MetricInfo.Builder> usageMetric) {
            return this.usageMetric((MetricInfo)((MetricInfo.Builder)MetricInfo.builder().applyMutation(usageMetric)).build());
        }

        public Builder period(QuotaPeriod var1);

        default public Builder period(Consumer<QuotaPeriod.Builder> period) {
            return this.period((QuotaPeriod)((QuotaPeriod.Builder)QuotaPeriod.builder().applyMutation(period)).build());
        }

        public Builder errorReason(ErrorReason var1);

        default public Builder errorReason(Consumer<ErrorReason.Builder> errorReason) {
            return this.errorReason((ErrorReason)((ErrorReason.Builder)ErrorReason.builder().applyMutation(errorReason)).build());
        }
    }
}

