/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ServiceTypeOption {
    HTTP("HTTP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ServiceTypeOption> VALUE_MAP;
    private final String value;

    private ServiceTypeOption(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ServiceTypeOption fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ServiceTypeOption> knownValues() {
        EnumSet<ServiceTypeOption> knownValues = EnumSet.allOf(ServiceTypeOption.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ServiceTypeOption.class, ServiceTypeOption::toString);
    }
}

