/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicediscovery.model.HttpInstanceSummary;
import software.amazon.awssdk.services.servicediscovery.model.HttpInstanceSummaryListCopier;
import software.amazon.awssdk.services.servicediscovery.model.ServiceDiscoveryResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DiscoverInstancesResponse
extends ServiceDiscoveryResponse
implements ToCopyableBuilder<Builder, DiscoverInstancesResponse> {
    private static final SdkField<List<HttpInstanceSummary>> INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Instances").getter(DiscoverInstancesResponse.getter(DiscoverInstancesResponse::instances)).setter(DiscoverInstancesResponse.setter(Builder::instances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Instances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HttpInstanceSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCES_FIELD));
    private final List<HttpInstanceSummary> instances;

    private DiscoverInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.instances = builder.instances;
    }

    public boolean hasInstances() {
        return this.instances != null && !(this.instances instanceof SdkAutoConstructList);
    }

    public List<HttpInstanceSummary> instances() {
        return this.instances;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instances());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiscoverInstancesResponse)) {
            return false;
        }
        DiscoverInstancesResponse other = (DiscoverInstancesResponse)((Object)obj);
        return Objects.equals(this.instances(), other.instances());
    }

    public String toString() {
        return ToString.builder((String)"DiscoverInstancesResponse").add("Instances", this.instances()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Instances": {
                return Optional.ofNullable(clazz.cast(this.instances()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DiscoverInstancesResponse, T> g) {
        return obj -> g.apply((DiscoverInstancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceDiscoveryResponse.BuilderImpl
    implements Builder {
        private List<HttpInstanceSummary> instances = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DiscoverInstancesResponse model) {
            super(model);
            this.instances(model.instances);
        }

        public final Collection<HttpInstanceSummary.Builder> getInstances() {
            return this.instances != null ? (Collection)this.instances.stream().map(HttpInstanceSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instances(Collection<HttpInstanceSummary> instances) {
            this.instances = HttpInstanceSummaryListCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(HttpInstanceSummary ... instances) {
            this.instances(Arrays.asList(instances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Consumer<HttpInstanceSummary.Builder> ... instances) {
            this.instances(Stream.of(instances).map(c -> (HttpInstanceSummary)((HttpInstanceSummary.Builder)HttpInstanceSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstances(Collection<HttpInstanceSummary.BuilderImpl> instances) {
            this.instances = HttpInstanceSummaryListCopier.copyFromBuilder(instances);
        }

        @Override
        public DiscoverInstancesResponse build() {
            return new DiscoverInstancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceDiscoveryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DiscoverInstancesResponse> {
        public Builder instances(Collection<HttpInstanceSummary> var1);

        public Builder instances(HttpInstanceSummary ... var1);

        public Builder instances(Consumer<HttpInstanceSummary.Builder> ... var1);
    }
}

