/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.servicediscovery.model.DnsConfig;
import software.amazon.awssdk.services.servicediscovery.model.HealthCheckConfig;
import software.amazon.awssdk.services.servicediscovery.transform.ServiceMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Service
implements StructuredPojo,
ToCopyableBuilder<Builder, Service> {
    private final String id;
    private final String arn;
    private final String name;
    private final String description;
    private final Integer instanceCount;
    private final DnsConfig dnsConfig;
    private final HealthCheckConfig healthCheckConfig;
    private final Instant createDate;
    private final String creatorRequestId;

    private Service(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.instanceCount = builder.instanceCount;
        this.dnsConfig = builder.dnsConfig;
        this.healthCheckConfig = builder.healthCheckConfig;
        this.createDate = builder.createDate;
        this.creatorRequestId = builder.creatorRequestId;
    }

    public String id() {
        return this.id;
    }

    public String arn() {
        return this.arn;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public Integer instanceCount() {
        return this.instanceCount;
    }

    public DnsConfig dnsConfig() {
        return this.dnsConfig;
    }

    public HealthCheckConfig healthCheckConfig() {
        return this.healthCheckConfig;
    }

    public Instant createDate() {
        return this.createDate;
    }

    public String creatorRequestId() {
        return this.creatorRequestId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorRequestId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Service)) {
            return false;
        }
        Service other = (Service)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.instanceCount(), other.instanceCount()) && Objects.equals(this.dnsConfig(), other.dnsConfig()) && Objects.equals(this.healthCheckConfig(), other.healthCheckConfig()) && Objects.equals(this.createDate(), other.createDate()) && Objects.equals(this.creatorRequestId(), other.creatorRequestId());
    }

    public String toString() {
        return ToString.builder((String)"Service").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("InstanceCount", (Object)this.instanceCount()).add("DnsConfig", (Object)this.dnsConfig()).add("HealthCheckConfig", (Object)this.healthCheckConfig()).add("CreateDate", (Object)this.createDate()).add("CreatorRequestId", (Object)this.creatorRequestId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "Arn": {
                return Optional.of(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "InstanceCount": {
                return Optional.of(clazz.cast(this.instanceCount()));
            }
            case "DnsConfig": {
                return Optional.of(clazz.cast(this.dnsConfig()));
            }
            case "HealthCheckConfig": {
                return Optional.of(clazz.cast(this.healthCheckConfig()));
            }
            case "CreateDate": {
                return Optional.of(clazz.cast(this.createDate()));
            }
            case "CreatorRequestId": {
                return Optional.of(clazz.cast(this.creatorRequestId()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ServiceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String name;
        private String description;
        private Integer instanceCount;
        private DnsConfig dnsConfig;
        private HealthCheckConfig healthCheckConfig;
        private Instant createDate;
        private String creatorRequestId;

        private BuilderImpl() {
        }

        private BuilderImpl(Service model) {
            this.id(model.id);
            this.arn(model.arn);
            this.name(model.name);
            this.description(model.description);
            this.instanceCount(model.instanceCount);
            this.dnsConfig(model.dnsConfig);
            this.healthCheckConfig(model.healthCheckConfig);
            this.createDate(model.createDate);
            this.creatorRequestId(model.creatorRequestId);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final DnsConfig.Builder getDnsConfig() {
            return this.dnsConfig != null ? this.dnsConfig.toBuilder() : null;
        }

        @Override
        public final Builder dnsConfig(DnsConfig dnsConfig) {
            this.dnsConfig = dnsConfig;
            return this;
        }

        public final void setDnsConfig(DnsConfig.BuilderImpl dnsConfig) {
            this.dnsConfig = dnsConfig != null ? dnsConfig.build() : null;
        }

        public final HealthCheckConfig.Builder getHealthCheckConfig() {
            return this.healthCheckConfig != null ? this.healthCheckConfig.toBuilder() : null;
        }

        @Override
        public final Builder healthCheckConfig(HealthCheckConfig healthCheckConfig) {
            this.healthCheckConfig = healthCheckConfig;
            return this;
        }

        public final void setHealthCheckConfig(HealthCheckConfig.BuilderImpl healthCheckConfig) {
            this.healthCheckConfig = healthCheckConfig != null ? healthCheckConfig.build() : null;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public final String getCreatorRequestId() {
            return this.creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        public Service build() {
            return new Service(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Service> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder instanceCount(Integer var1);

        public Builder dnsConfig(DnsConfig var1);

        default public Builder dnsConfig(Consumer<DnsConfig.Builder> dnsConfig) {
            return this.dnsConfig((DnsConfig)((DnsConfig.Builder)DnsConfig.builder().apply(dnsConfig)).build());
        }

        public Builder healthCheckConfig(HealthCheckConfig var1);

        default public Builder healthCheckConfig(Consumer<HealthCheckConfig.Builder> healthCheckConfig) {
            return this.healthCheckConfig((HealthCheckConfig)((HealthCheckConfig.Builder)HealthCheckConfig.builder().apply(healthCheckConfig)).build());
        }

        public Builder createDate(Instant var1);

        public Builder creatorRequestId(String var1);
    }
}

