/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.servicediscovery.ServiceDiscoveryClient;
import software.amazon.awssdk.services.servicediscovery.model.ListServicesRequest;
import software.amazon.awssdk.services.servicediscovery.model.ListServicesResponse;

public final class ListServicesPaginator
implements SdkIterable<ListServicesResponse> {
    private final ServiceDiscoveryClient client;
    private final ListServicesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListServicesPaginator(ServiceDiscoveryClient client, ListServicesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListServicesResponseFetcher();
    }

    public Iterator<ListServicesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class ListServicesResponseFetcher
    implements NextPageFetcher<ListServicesResponse> {
        private ListServicesResponseFetcher() {
        }

        public boolean hasNextPage(ListServicesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListServicesResponse nextPage(ListServicesResponse previousPage) {
            if (previousPage == null) {
                return ListServicesPaginator.this.client.listServices(ListServicesPaginator.this.firstRequest);
            }
            return ListServicesPaginator.this.client.listServices((ListServicesRequest)((Object)ListServicesPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

