/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.servicediscovery.ServiceDiscoveryClient;
import software.amazon.awssdk.services.servicediscovery.model.ListOperationsRequest;
import software.amazon.awssdk.services.servicediscovery.model.ListOperationsResponse;

public final class ListOperationsPaginator
implements SdkIterable<ListOperationsResponse> {
    private final ServiceDiscoveryClient client;
    private final ListOperationsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListOperationsPaginator(ServiceDiscoveryClient client, ListOperationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListOperationsResponseFetcher();
    }

    public Iterator<ListOperationsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class ListOperationsResponseFetcher
    implements NextPageFetcher<ListOperationsResponse> {
        private ListOperationsResponseFetcher() {
        }

        public boolean hasNextPage(ListOperationsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListOperationsResponse nextPage(ListOperationsResponse previousPage) {
            if (previousPage == null) {
                return ListOperationsPaginator.this.client.listOperations(ListOperationsPaginator.this.firstRequest);
            }
            return ListOperationsPaginator.this.client.listOperations((ListOperationsRequest)((Object)ListOperationsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

