/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.servicediscovery.ServiceDiscoveryClient;
import software.amazon.awssdk.services.servicediscovery.model.ListNamespacesRequest;
import software.amazon.awssdk.services.servicediscovery.model.ListNamespacesResponse;

public final class ListNamespacesPaginator
implements SdkIterable<ListNamespacesResponse> {
    private final ServiceDiscoveryClient client;
    private final ListNamespacesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListNamespacesPaginator(ServiceDiscoveryClient client, ListNamespacesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListNamespacesResponseFetcher();
    }

    public Iterator<ListNamespacesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class ListNamespacesResponseFetcher
    implements NextPageFetcher<ListNamespacesResponse> {
        private ListNamespacesResponseFetcher() {
        }

        public boolean hasNextPage(ListNamespacesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListNamespacesResponse nextPage(ListNamespacesResponse previousPage) {
            if (previousPage == null) {
                return ListNamespacesPaginator.this.client.listNamespaces(ListNamespacesPaginator.this.firstRequest);
            }
            return ListNamespacesPaginator.this.client.listNamespaces((ListNamespacesRequest)((Object)ListNamespacesPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

